/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.Collections;
import java.util.List;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.MultiKeyPipelineBase;
import redis.clients.jedis.PipelineBase;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.params.LPosParams;

class JedisListCommands
implements RedisListCommands {
    private final JedisConnection connection;

    JedisListCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long rPush(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::rpush, PipelineBase::rpush, key, values);
    }

    @Override
    public List<Long> lPos(byte[] key, byte[] element, @Nullable Integer rank, @Nullable Integer count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)element, (String)"Element must not be null!");
        LPosParams params = new LPosParams();
        if (rank != null) {
            params.rank(rank.intValue());
        }
        if (count != null) {
            return this.connection.invoke().just(BinaryJedis::lpos, PipelineBase::lpos, key, element, params, count);
        }
        return this.connection.invoke().from(BinaryJedis::lpos, PipelineBase::lpos, key, element, params).getOrElse(Collections::singletonList, Collections::emptyList);
    }

    @Override
    public Long lPush(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)values, (String)"Values must not be null!");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements!");
        return this.connection.invoke().just(BinaryJedis::lpush, PipelineBase::lpush, key, values);
    }

    @Override
    public Long rPushX(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.connection.invoke().just((rec$, x$0, xva$1) -> rec$.rpushx(x$0, (byte[][])new byte[][]{xva$1}), (rec$, x$0, xva$1) -> rec$.rpushx(x$0, (byte[][])new byte[][]{xva$1}), key, value);
    }

    @Override
    public Long lPushX(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.connection.invoke().just((rec$, x$0, xva$1) -> rec$.lpushx(x$0, (byte[][])new byte[][]{xva$1}), (rec$, x$0, xva$1) -> rec$.lpushx(x$0, (byte[][])new byte[][]{xva$1}), key, value);
    }

    @Override
    public Long lLen(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::llen, PipelineBase::llen, key);
    }

    @Override
    public List<byte[]> lRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::lrange, PipelineBase::lrange, key, start, end);
    }

    @Override
    public void lTrim(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        this.connection.invokeStatus().just(BinaryJedis::ltrim, PipelineBase::ltrim, key, start, end);
    }

    @Override
    public byte[] lIndex(byte[] key, long index) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::lindex, PipelineBase::lindex, key, index);
    }

    @Override
    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::linsert, PipelineBase::linsert, key, JedisConverters.toListPosition(where), pivot, value);
    }

    @Override
    public void lSet(byte[] key, long index, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        this.connection.invokeStatus().just(BinaryJedis::lset, PipelineBase::lset, key, index, value);
    }

    @Override
    public Long lRem(byte[] key, long count, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.connection.invoke().just(BinaryJedis::lrem, PipelineBase::lrem, key, count, value);
    }

    @Override
    public byte[] lPop(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::lpop, PipelineBase::lpop, key);
    }

    @Override
    public byte[] rPop(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::rpop, PipelineBase::rpop, key);
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Key must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        return this.connection.invoke().just(BinaryJedis::blpop, MultiKeyPipelineBase::blpop, JedisListCommands.bXPopArgs(timeout, keys));
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Key must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        return this.connection.invoke().just(BinaryJedis::brpop, MultiKeyPipelineBase::brpop, JedisListCommands.bXPopArgs(timeout, keys));
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        Assert.notNull((Object)srcKey, (String)"Source key must not be null!");
        Assert.notNull((Object)dstKey, (String)"Destination key must not be null!");
        return this.connection.invoke().just(BinaryJedis::rpoplpush, MultiKeyPipelineBase::rpoplpush, srcKey, dstKey);
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        Assert.notNull((Object)srcKey, (String)"Source key must not be null!");
        Assert.notNull((Object)dstKey, (String)"Destination key must not be null!");
        return this.connection.invoke().just(BinaryJedis::brpoplpush, MultiKeyPipelineBase::brpoplpush, srcKey, dstKey, timeout);
    }

    private static byte[][] bXPopArgs(int timeout, byte[] ... keys) {
        byte[][] args = new byte[keys.length + 1][];
        System.arraycopy(keys, 0, args, 0, keys.length);
        args[args.length - 1] = Protocol.toByteArray((int)timeout);
        return args;
    }
}

