/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.args.ListDirection;
import redis.clients.jedis.params.LPosParams;

class JedisClusterListCommands
implements RedisListCommands {
    private final JedisClusterConnection connection;

    JedisClusterListCommands(JedisClusterConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long rPush(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().rpush(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<Long> lPos(byte[] key, byte[] element, @Nullable Integer rank, @Nullable Integer count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)element, (String)"Element must not be null!");
        LPosParams params = new LPosParams();
        if (rank != null) {
            params.rank(rank.intValue());
        }
        try {
            if (count != null) {
                return this.connection.getCluster().lpos(key, element, params, (long)count.intValue());
            }
            Long value = this.connection.getCluster().lpos(key, element, params);
            return value != null ? Collections.singletonList(value) : Collections.emptyList();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lPush(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)values, (String)"Values must not be null!");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements!");
        try {
            return this.connection.getCluster().lpush(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long rPushX(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            return this.connection.getCluster().rpushx(key, (byte[][])new byte[][]{value});
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lPushX(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            return this.connection.getCluster().lpushx(key, (byte[][])new byte[][]{value});
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lLen(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().llen(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> lRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().lrange(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void lTrim(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            this.connection.getCluster().ltrim(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] lIndex(byte[] key, long index) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().lindex(key, index);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().linsert(key, JedisConverters.toListPosition(where), pivot, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] lMove(byte[] sourceKey, byte[] destinationKey, RedisListCommands.Direction from, RedisListCommands.Direction to) {
        Assert.notNull((Object)sourceKey, (String)"Source key must not be null!");
        Assert.notNull((Object)destinationKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)((Object)from), (String)"From direction must not be null!");
        Assert.notNull((Object)((Object)to), (String)"To direction must not be null!");
        try {
            return this.connection.getCluster().lmove(sourceKey, destinationKey, ListDirection.valueOf((String)from.name()), ListDirection.valueOf((String)to.name()));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] bLMove(byte[] sourceKey, byte[] destinationKey, RedisListCommands.Direction from, RedisListCommands.Direction to, double timeout) {
        Assert.notNull((Object)sourceKey, (String)"Source key must not be null!");
        Assert.notNull((Object)destinationKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)((Object)from), (String)"From direction must not be null!");
        Assert.notNull((Object)((Object)to), (String)"To direction must not be null!");
        try {
            return this.connection.getCluster().blmove(sourceKey, destinationKey, ListDirection.valueOf((String)from.name()), ListDirection.valueOf((String)to.name()), timeout);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void lSet(byte[] key, long index, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            this.connection.getCluster().lset(key, index, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lRem(byte[] key, long count, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            return this.connection.getCluster().lrem(key, count, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] lPop(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().lpop(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> lPop(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().lpop(key, (int)count);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] rPop(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().rpop(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> rPop(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().rpop(key, (int)count);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Key must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            try {
                return this.connection.getCluster().blpop(timeout, keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        return this.connection.getClusterCommandExecutor().executeMultiKeyCommand((client, key) -> client.blpop(timeout, (byte[][])new byte[][]{key}), Arrays.asList(keys)).getFirstNonNullNotEmptyOrDefault(Collections.emptyList());
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Key must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            try {
                return this.connection.getCluster().brpop(timeout, keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        return this.connection.getClusterCommandExecutor().executeMultiKeyCommand((client, key) -> client.brpop(timeout, (byte[][])new byte[][]{key}), Arrays.asList(keys)).getFirstNonNullNotEmptyOrDefault(Collections.emptyList());
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        Assert.notNull((Object)srcKey, (String)"Source key must not be null!");
        Assert.notNull((Object)dstKey, (String)"Destination key must not be null!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(srcKey, dstKey)) {
            try {
                return this.connection.getCluster().rpoplpush(srcKey, dstKey);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        byte[] val = this.rPop(srcKey);
        this.lPush(dstKey, new byte[][]{val});
        return val;
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        Assert.notNull((Object)srcKey, (String)"Source key must not be null!");
        Assert.notNull((Object)dstKey, (String)"Destination key must not be null!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(srcKey, dstKey)) {
            try {
                return this.connection.getCluster().brpoplpush(srcKey, dstKey, timeout);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        List<byte[]> val = this.bRPop(timeout, new byte[][]{srcKey});
        if (!CollectionUtils.isEmpty(val)) {
            this.lPush(dstKey, new byte[][]{val.get(1)});
            return val.get(1);
        }
        return null;
    }

    private DataAccessException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }
}

