/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Insert;
import org.springframework.data.relational.core.sql.Into;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.Values;
import org.springframework.data.relational.core.sql.Visitor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class DefaultInsert
implements Insert {
    private final Into into;
    private final List<Column> columns;
    private final Values values;

    DefaultInsert(@Nullable Table into, List<Column> columns, List<Expression> values) {
        this.into = new Into(into);
        this.columns = new ArrayList<Column>(columns);
        this.values = new Values(new ArrayList<Expression>(values));
    }

    @Override
    public void visit(Visitor visitor) {
        Assert.notNull((Object)visitor, (String)"Visitor must not be null!");
        visitor.enter(this);
        this.into.visit(visitor);
        this.columns.forEach(it -> it.visit(visitor));
        this.values.visit(visitor);
        visitor.leave(this);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT ").append(this.into);
        if (!this.columns.isEmpty()) {
            builder.append(" (").append(StringUtils.collectionToDelimitedString(this.columns, (String)", ")).append(")");
        }
        builder.append(" ").append(this.values);
        return builder.toString();
    }
}

