/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.repository.support;

import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.repository.query.RelationalEntityInformation;
import org.springframework.data.repository.core.support.PersistentEntityInformation;
import org.springframework.lang.Nullable;

public class MappingRelationalEntityInformation<T, ID>
extends PersistentEntityInformation<T, ID>
implements RelationalEntityInformation<T, ID> {
    private final RelationalPersistentEntity<T> entityMetadata;
    @Nullable
    private final String customTableName;
    private final Class<ID> fallbackIdType;

    public MappingRelationalEntityInformation(RelationalPersistentEntity<T> entity) {
        this(entity, null, null);
    }

    public MappingRelationalEntityInformation(RelationalPersistentEntity<T> entity, @Nullable Class<ID> fallbackIdType) {
        this(entity, null, fallbackIdType);
    }

    public MappingRelationalEntityInformation(RelationalPersistentEntity<T> entity, String customTableName) {
        this(entity, customTableName, null);
    }

    private MappingRelationalEntityInformation(RelationalPersistentEntity<T> entity, @Nullable String customTableName, @Nullable Class<ID> idType) {
        super(entity);
        this.entityMetadata = entity;
        this.customTableName = customTableName;
        this.fallbackIdType = idType != null ? idType : Long.class;
    }

    @Override
    public String getTableName() {
        return this.customTableName == null ? this.entityMetadata.getTableName() : this.customTableName;
    }

    public String getIdAttribute() {
        return ((RelationalPersistentProperty)this.entityMetadata.getRequiredIdProperty()).getName();
    }

    public Class<ID> getIdType() {
        if (this.entityMetadata.hasIdProperty()) {
            return super.getIdType();
        }
        return this.fallbackIdType;
    }
}

