/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.dialect;

import java.util.List;
import org.springframework.data.relational.core.dialect.AbstractDialect;
import org.springframework.data.relational.core.dialect.ArrayColumns;
import org.springframework.data.relational.core.dialect.LimitClause;
import org.springframework.data.relational.core.dialect.LockClause;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.LockOptions;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class PostgresDialect
extends AbstractDialect {
    public static final PostgresDialect INSTANCE = new PostgresDialect();
    private static final LimitClause LIMIT_CLAUSE = new LimitClause(){

        @Override
        public String getLimit(long limit) {
            return "LIMIT " + limit;
        }

        @Override
        public String getOffset(long offset) {
            return "OFFSET " + offset;
        }

        @Override
        public String getLimitOffset(long limit, long offset) {
            return String.format("LIMIT %d OFFSET %d", limit, offset);
        }

        @Override
        public LimitClause.Position getClausePosition() {
            return LimitClause.Position.AFTER_ORDER_BY;
        }
    };
    private final PostgresArrayColumns ARRAY_COLUMNS = new PostgresArrayColumns();
    private final PostgresLockClause LOCK_CLAUSE = new PostgresLockClause(this.getIdentifierProcessing());

    protected PostgresDialect() {
    }

    @Override
    public LimitClause limit() {
        return LIMIT_CLAUSE;
    }

    @Override
    public LockClause lock() {
        return this.LOCK_CLAUSE;
    }

    @Override
    public ArrayColumns getArraySupport() {
        return this.ARRAY_COLUMNS;
    }

    @Override
    public IdentifierProcessing getIdentifierProcessing() {
        return IdentifierProcessing.create(IdentifierProcessing.Quoting.ANSI, IdentifierProcessing.LetterCasing.LOWER_CASE);
    }

    static class PostgresArrayColumns
    implements ArrayColumns {
        @Override
        public boolean isSupported() {
            return true;
        }

        @Override
        public Class<?> getArrayType(Class<?> userType) {
            Assert.notNull(userType, (String)"Array component type must not be null");
            return ClassUtils.resolvePrimitiveIfNecessary(userType);
        }
    }

    static class PostgresLockClause
    implements LockClause {
        private final IdentifierProcessing identifierProcessing;

        PostgresLockClause(IdentifierProcessing identifierProcessing) {
            this.identifierProcessing = identifierProcessing;
        }

        @Override
        public String getLock(LockOptions lockOptions) {
            List<Table> tables = lockOptions.getFrom().getTables();
            if (tables.isEmpty()) {
                return "";
            }
            String tableName = tables.get(0).getName().toSql(this.identifierProcessing);
            switch (lockOptions.getLockMode()) {
                case PESSIMISTIC_WRITE: {
                    return "FOR UPDATE OF " + tableName;
                }
                case PESSIMISTIC_READ: {
                    return "FOR SHARE OF " + tableName;
                }
            }
            return "";
        }

        @Override
        public LockClause.Position getClausePosition() {
            return LockClause.Position.AFTER_ORDER_BY;
        }
    }
}

