/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.repository.query;

import java.util.Collection;
import java.util.Collections;
import org.springframework.data.relational.core.query.Criteria;
import org.springframework.data.relational.repository.query.ParameterMetadata;
import org.springframework.data.relational.repository.query.ParameterMetadataProvider;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

class CriteriaFactory {
    private final ParameterMetadataProvider parameterMetadataProvider;

    public CriteriaFactory(ParameterMetadataProvider parameterMetadataProvider) {
        Assert.notNull((Object)parameterMetadataProvider, (String)"Parameter metadata provider must not be null!");
        this.parameterMetadataProvider = parameterMetadataProvider;
    }

    public Criteria createCriteria(Part part) {
        Part.Type type = part.getType();
        String propertyName = part.getProperty().toDotPath();
        Class propertyType = part.getProperty().getType();
        Criteria.CriteriaStep criteriaStep = Criteria.where(propertyName);
        if (type == Part.Type.IS_NULL || type == Part.Type.IS_NOT_NULL) {
            return part.getType() == Part.Type.IS_NULL ? criteriaStep.isNull() : criteriaStep.isNotNull();
        }
        if (type == Part.Type.TRUE || type == Part.Type.FALSE) {
            return part.getType() == Part.Type.TRUE ? criteriaStep.isTrue() : criteriaStep.isFalse();
        }
        switch (type) {
            case BETWEEN: {
                ParameterMetadata geParamMetadata = this.parameterMetadataProvider.next(part);
                ParameterMetadata leParamMetadata = this.parameterMetadataProvider.next(part);
                return criteriaStep.between(geParamMetadata.getValue(), leParamMetadata.getValue());
            }
            case AFTER: 
            case GREATER_THAN: {
                ParameterMetadata paramMetadata = this.parameterMetadataProvider.next(part);
                return criteriaStep.greaterThan(paramMetadata.getValue());
            }
            case GREATER_THAN_EQUAL: {
                ParameterMetadata paramMetadata = this.parameterMetadataProvider.next(part);
                return criteriaStep.greaterThanOrEquals(paramMetadata.getValue());
            }
            case BEFORE: 
            case LESS_THAN: {
                ParameterMetadata paramMetadata = this.parameterMetadataProvider.next(part);
                return criteriaStep.lessThan(paramMetadata.getValue());
            }
            case LESS_THAN_EQUAL: {
                ParameterMetadata paramMetadata = this.parameterMetadataProvider.next(part);
                return criteriaStep.lessThanOrEquals(paramMetadata.getValue());
            }
            case IN: 
            case NOT_IN: {
                ParameterMetadata paramMetadata = this.parameterMetadataProvider.next(part);
                Criteria criteria = part.getType() == Part.Type.IN ? criteriaStep.in(CriteriaFactory.asCollection(paramMetadata.getValue())) : criteriaStep.notIn(CriteriaFactory.asCollection(paramMetadata.getValue()));
                return criteria.ignoreCase(this.shouldIgnoreCase(part) && this.checkCanUpperCase(part, part.getProperty().getType()));
            }
            case STARTING_WITH: 
            case ENDING_WITH: 
            case CONTAINING: 
            case NOT_CONTAINING: 
            case LIKE: 
            case NOT_LIKE: {
                ParameterMetadata paramMetadata = this.parameterMetadataProvider.next(part);
                Criteria criteria = part.getType() == Part.Type.NOT_LIKE || part.getType() == Part.Type.NOT_CONTAINING ? criteriaStep.notLike(paramMetadata.getValue()) : criteriaStep.like(paramMetadata.getValue());
                return criteria.ignoreCase(this.shouldIgnoreCase(part) && this.checkCanUpperCase(part, propertyType, paramMetadata.getType()));
            }
            case SIMPLE_PROPERTY: {
                ParameterMetadata paramMetadata = this.parameterMetadataProvider.next(part);
                if (paramMetadata.getValue() == null) {
                    return criteriaStep.isNull();
                }
                return criteriaStep.is(paramMetadata.getValue()).ignoreCase(this.shouldIgnoreCase(part) && this.checkCanUpperCase(part, propertyType, paramMetadata.getType()));
            }
            case NEGATING_SIMPLE_PROPERTY: {
                ParameterMetadata paramMetadata = this.parameterMetadataProvider.next(part);
                return criteriaStep.not(paramMetadata.getValue()).ignoreCase(this.shouldIgnoreCase(part) && this.checkCanUpperCase(part, propertyType, paramMetadata.getType()));
            }
        }
        throw new IllegalArgumentException("Unsupported keyword " + type);
    }

    private boolean shouldIgnoreCase(Part part) {
        return part.shouldIgnoreCase() == Part.IgnoreCaseType.ALWAYS || part.shouldIgnoreCase() == Part.IgnoreCaseType.WHEN_POSSIBLE;
    }

    private boolean checkCanUpperCase(Part part, Class<?> ... expressionTypes) {
        Assert.notEmpty((Object[])expressionTypes, (String)"Expression types must not be null or empty");
        boolean strict = part.shouldIgnoreCase() == Part.IgnoreCaseType.ALWAYS;
        for (Class<?> expressionType : expressionTypes) {
            if (this.canUpperCase(expressionType)) continue;
            if (strict) {
                throw new IllegalStateException("Unable to ignore case of " + expressionType.getName() + " type, the property '" + part.getProperty().getSegment() + "' must reference a string");
            }
            return false;
        }
        return true;
    }

    private boolean canUpperCase(Class<?> expressionType) {
        return expressionType == String.class;
    }

    private static Collection<Object> asCollection(Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value.getClass().isArray()) {
            return CollectionUtils.arrayToList((Object)value);
        }
        return Collections.singletonList(value);
    }
}

