/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.repository.AttributeMetadata;
import org.springframework.data.rest.repository.RepositoryExporter;
import org.springframework.data.rest.repository.RepositoryMetadata;
import org.springframework.data.rest.repository.RepositoryNotFoundException;

public abstract class RepositoryExporterSupport<S extends RepositoryExporterSupport<? super S>> {
    protected List<RepositoryExporter> repositoryExporters = Collections.emptyList();

    public List<RepositoryExporter> getRepositoryExporters() {
        return this.repositoryExporters;
    }

    @Autowired(required=false)
    public void setRepositoryExporters(List<RepositoryExporter> repositoryExporters) {
        this.repositoryExporters = repositoryExporters;
    }

    public List<RepositoryExporter> repositoryExporters() {
        return this.repositoryExporters;
    }

    public S repositoryExporters(List<RepositoryExporter> repositoryExporters) {
        this.setRepositoryExporters(repositoryExporters);
        return (S)this;
    }

    public S repositoryExporters(RepositoryExporter ... repositoryExporter) {
        this.setRepositoryExporters(Arrays.asList(repositoryExporter));
        return (S)this;
    }

    public boolean hasRepositoryMetadataFor(String name) {
        try {
            return null != this.repositoryMetadataFor(name);
        }
        catch (RepositoryNotFoundException ignored) {
            return false;
        }
    }

    public boolean hasRepositoryMetadataFor(Class<?> domainType) {
        try {
            return null != this.repositoryMetadataFor(domainType);
        }
        catch (RepositoryNotFoundException ignored) {
            return false;
        }
    }

    protected RepositoryMetadata repositoryMetadataFor(String name) {
        for (RepositoryExporter exporter : this.repositoryExporters) {
            Object repoMeta = exporter.repositoryMetadataFor(name);
            if (null == repoMeta) continue;
            return repoMeta;
        }
        throw new RepositoryNotFoundException("No repository found for name " + name);
    }

    protected RepositoryMetadata repositoryMetadataFor(Class<?> domainType) {
        for (RepositoryExporter exporter : this.repositoryExporters) {
            Object repoMeta = exporter.repositoryMetadataFor(domainType);
            if (null == repoMeta) continue;
            return repoMeta;
        }
        throw new RepositoryNotFoundException("No repository found for type " + domainType.getName());
    }

    protected RepositoryMetadata repositoryMetadataFor(AttributeMetadata attrMeta) {
        if (null != attrMeta.elementType()) {
            return this.repositoryMetadataFor(attrMeta.elementType());
        }
        return this.repositoryMetadataFor(attrMeta.type());
    }
}

