/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.rest.repository.EntityMetadata;
import org.springframework.validation.AbstractErrors;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class ValidationErrors
extends AbstractErrors {
    private String name;
    private Object entity;
    private EntityMetadata entityMetadata;
    private List<ObjectError> globalErrors = new ArrayList<ObjectError>();
    private List<FieldError> fieldErrors = new ArrayList<FieldError>();

    public ValidationErrors(String name, Object entity, EntityMetadata entityMetadata) {
        this.name = name;
        this.entity = entity;
        this.entityMetadata = entityMetadata;
    }

    public String getObjectName() {
        return this.name;
    }

    public void reject(String errorCode, Object[] errorArgs, String defaultMessage) {
        this.globalErrors.add(new ObjectError(this.name, new String[]{errorCode}, errorArgs, defaultMessage));
    }

    public void rejectValue(String field, String errorCode, Object[] errorArgs, String defaultMessage) {
        this.fieldErrors.add(new FieldError(this.name, field, this.getFieldValue(field), true, new String[]{errorCode}, errorArgs, defaultMessage));
    }

    public void addAllErrors(Errors errors) {
        this.globalErrors.addAll(errors.getAllErrors());
    }

    public List<ObjectError> getGlobalErrors() {
        return this.globalErrors;
    }

    public List<FieldError> getFieldErrors() {
        return this.fieldErrors;
    }

    public Object getFieldValue(String field) {
        return this.entityMetadata.attribute(field).get(this.entity);
    }
}

