/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository.jpa;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.repository.EntityMetadata;
import org.springframework.data.rest.repository.annotation.RestResource;
import org.springframework.data.rest.repository.jpa.JpaAttributeMetadata;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class JpaEntityMetadata
implements EntityMetadata<JpaAttributeMetadata> {
    private Class<?> type;
    private JpaAttributeMetadata idAttribute;
    private JpaAttributeMetadata versionAttribute;
    private Map<String, JpaAttributeMetadata> embeddedAttributes = new HashMap<String, JpaAttributeMetadata>();
    private Map<String, JpaAttributeMetadata> linkedAttributes = new HashMap<String, JpaAttributeMetadata>();

    public JpaEntityMetadata(Repositories repositories, EntityType<?> entityType) {
        this.type = entityType.getJavaType();
        this.idAttribute = new JpaAttributeMetadata(entityType, (Attribute)entityType.getId(entityType.getIdType().getJavaType()));
        try {
            if (null != entityType.getVersion(Long.class)) {
                this.versionAttribute = new JpaAttributeMetadata(entityType, (Attribute)entityType.getVersion(Long.class));
            }
        }
        catch (IllegalArgumentException ignored) {
            // empty catch block
        }
        for (Attribute attr : entityType.getAttributes()) {
            Class attrType;
            boolean exported = true;
            Field field = ReflectionUtils.findField(this.type, (String)attr.getJavaMember().getName());
            if (null == field) continue;
            RestResource fieldResourceAnno = field.getAnnotation(RestResource.class);
            if (null != fieldResourceAnno) {
                exported = fieldResourceAnno.exported();
            }
            if (!exported) continue;
            String name = attr.getName();
            if (null != fieldResourceAnno && StringUtils.hasText((String)fieldResourceAnno.path())) {
                name = fieldResourceAnno.path();
            }
            Class clazz = attrType = attr instanceof PluralAttribute ? ((PluralAttribute)attr).getElementType().getJavaType() : attr.getJavaType();
            if (repositories.hasRepositoryFor(attrType)) {
                this.linkedAttributes.put(name, new JpaAttributeMetadata(entityType, attr));
                continue;
            }
            if (attr instanceof SingularAttribute && ((SingularAttribute)attr).isId() || attr instanceof SingularAttribute && ((SingularAttribute)attr).isVersion() && (null == fieldResourceAnno || !StringUtils.hasText((String)fieldResourceAnno.path()))) continue;
            this.embeddedAttributes.put(name, new JpaAttributeMetadata(entityType, attr));
        }
    }

    @Override
    public Class<?> type() {
        return this.type;
    }

    @Override
    public Map<String, JpaAttributeMetadata> embeddedAttributes() {
        return this.embeddedAttributes;
    }

    @Override
    public Map<String, JpaAttributeMetadata> linkedAttributes() {
        return this.linkedAttributes;
    }

    @Override
    public JpaAttributeMetadata idAttribute() {
        return this.idAttribute;
    }

    @Override
    public JpaAttributeMetadata versionAttribute() {
        return this.versionAttribute;
    }

    @Override
    public JpaAttributeMetadata attribute(String name) {
        if (this.idAttribute.name().equals(name)) {
            return this.idAttribute;
        }
        if (null != this.versionAttribute && this.versionAttribute.name().equals(name)) {
            return this.versionAttribute;
        }
        if (this.embeddedAttributes.containsKey(name)) {
            return this.embeddedAttributes.get(name);
        }
        if (this.linkedAttributes.containsKey(name)) {
            return this.linkedAttributes.get(name);
        }
        return null;
    }

    public String toString() {
        return "JpaEntityMetadata{type=" + this.type + ", idAttribute=" + this.idAttribute + ", versionAttribute=" + this.versionAttribute + ", embeddedAttributes=" + this.embeddedAttributes + ", linkedAttributes=" + this.linkedAttributes + '}';
    }
}

