/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository.jpa;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.Metamodel;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.repository.RepositoryMetadata;
import org.springframework.data.rest.repository.annotation.RestResource;
import org.springframework.data.rest.repository.invoke.CrudMethod;
import org.springframework.data.rest.repository.invoke.RepositoryQueryMethod;
import org.springframework.data.rest.repository.jpa.JpaEntityMetadata;
import org.springframework.data.rest.repository.support.Methods;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class JpaRepositoryMetadata
implements RepositoryMetadata<JpaEntityMetadata> {
    private final String name;
    private final Class<?> repoClass;
    private final CrudRepository<Object, Serializable> repository;
    private final EntityInformation entityInfo;
    private final Map<CrudMethod, Boolean> crudMethodExposed = new HashMap<CrudMethod, Boolean>();
    private final Map<String, RepositoryQueryMethod> queryMethods = new HashMap<String, RepositoryQueryMethod>();
    private String rel;
    private JpaEntityMetadata entityMetadata;

    public JpaRepositoryMetadata(String name, Class<?> domainType, Class<?> repoClass, Repositories repositories, EntityManager entityManager) {
        this.name = name;
        this.repoClass = repoClass;
        this.repository = repositories.getRepositoryFor(domainType);
        this.entityInfo = repositories.getEntityInformationFor(domainType);
        RestResource resourceAnno = repoClass.getAnnotation(RestResource.class);
        this.rel = null != resourceAnno && StringUtils.hasText((String)resourceAnno.rel()) ? resourceAnno.rel() : name;
        for (Method method : repositories.getRepositoryInformationFor(domainType).getQueryMethods()) {
            String pathSeg = method.getName();
            RestResource methodResourceAnno = method.getAnnotation(RestResource.class);
            boolean methodExported = true;
            if (null != methodResourceAnno) {
                if (StringUtils.hasText((String)methodResourceAnno.path())) {
                    pathSeg = methodResourceAnno.path();
                }
                methodExported = methodResourceAnno.exported();
            }
            if (!methodExported) continue;
            ReflectionUtils.makeAccessible((Method)method);
            this.queryMethods.put(pathSeg, new RepositoryQueryMethod(method));
        }
        ReflectionUtils.doWithMethods(repoClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                CrudMethod cr = CrudMethod.fromMethod(method);
                RestResource rr = method.getAnnotation(RestResource.class);
                if (null != rr) {
                    JpaRepositoryMetadata.this.crudMethodExposed.put(cr, rr.exported());
                }
            }
        }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                return null != CrudMethod.fromMethod(method) && Methods.USER_METHODS.matches(method);
            }
        });
        Metamodel metamodel = entityManager.getMetamodel();
        this.entityMetadata = new JpaEntityMetadata(repositories, metamodel.entity(this.entityInfo.getJavaType()));
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String rel() {
        return this.rel;
    }

    @Override
    public Class<?> domainType() {
        return this.entityMetadata.type();
    }

    @Override
    public Class<?> repositoryClass() {
        return this.repoClass;
    }

    @Override
    public CrudRepository<Object, Serializable> repository() {
        return this.repository;
    }

    @Override
    public JpaEntityMetadata entityMetadata() {
        return this.entityMetadata;
    }

    @Override
    public RepositoryQueryMethod queryMethod(String key) {
        return this.queryMethods.get(key);
    }

    @Override
    public Map<String, RepositoryQueryMethod> queryMethods() {
        return Collections.unmodifiableMap(this.queryMethods);
    }

    @Override
    public Boolean exportsMethod(CrudMethod method) {
        Boolean b = this.crudMethodExposed.get((Object)method);
        if (null == b) {
            return true;
        }
        return b;
    }

    public String toString() {
        return "JpaRepositoryMetadata{name='" + this.name + '\'' + ", repoClass=" + this.repoClass + ", repository=" + this.repository + ", entityInfo=" + this.entityInfo + ", queryMethods=" + this.queryMethods + ", entityMetadata=" + this.entityMetadata + '}';
    }
}

