/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.alps;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.rest.webmvc.alps.RootResourceInformationToAlpsDescriptorConverter;
import org.springframework.hateoas.alps.Alps;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.Assert;

public class AlpsJsonHttpMessageConverter
extends MappingJackson2HttpMessageConverter {
    private static final MediaType ALPS_MEDIA_TYPE = MediaType.parseMediaType((String)"application/alps+json");
    private final RootResourceInformationToAlpsDescriptorConverter converter;

    public AlpsJsonHttpMessageConverter(RootResourceInformationToAlpsDescriptorConverter converter) {
        Assert.notNull((Object)converter, (String)"Converter must not be null!");
        this.converter = converter;
        ObjectMapper mapper = this.getObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        this.setPrettyPrint(true);
        this.setSupportedMediaTypes(Arrays.asList(ALPS_MEDIA_TYPE, MediaType.APPLICATION_JSON, MediaType.ALL));
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return (clazz.isAssignableFrom(Alps.class) || clazz.isAssignableFrom(RootResourceInformation.class)) && super.canWrite(clazz, mediaType);
    }

    public boolean canRead(Type type, Class<?> contextClass, MediaType mediaType) {
        return false;
    }

    protected void writeInternal(Object object, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        Object toWrite = object instanceof RootResourceInformation ? this.converter.convert((RootResourceInformation)object) : object;
        super.writeInternal(toWrite, outputMessage);
    }
}

