/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.beans.ConstructorProperties;
import java.util.Calendar;
import lombok.NonNull;
import org.springframework.data.auditing.AuditableBeanWrapper;
import org.springframework.data.auditing.AuditableBeanWrapperFactory;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.support.ETag;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;

public class HttpHeadersPreparer {
    @NonNull
    private final AuditableBeanWrapperFactory auditableBeanWrapperFactory;

    public HttpHeaders prepareHeaders(PersistentEntityResource resource) {
        return resource == null ? new HttpHeaders() : this.prepareHeaders(resource.getPersistentEntity(), resource.getContent());
    }

    public HttpHeaders prepareHeaders(PersistentEntity<?, ?> entity, Object value) {
        HttpHeaders headers = ETag.from(entity, value).addTo(new HttpHeaders());
        AuditableBeanWrapper wrapper = this.getAuditableBeanWrapper(value);
        if (wrapper == null) {
            return headers;
        }
        Calendar lastModifiedDate = wrapper.getLastModifiedDate();
        if (lastModifiedDate != null) {
            headers.setLastModified(lastModifiedDate.getTimeInMillis());
        }
        return headers;
    }

    public boolean isObjectStillValid(Object source, HttpHeaders headers) {
        Assert.notNull((Object)source, (String)"Source object must not be null!");
        Assert.notNull((Object)headers, (String)"HttpHeaders must not be null!");
        if (headers.getIfModifiedSince() == -1L) {
            return false;
        }
        AuditableBeanWrapper wrapper = this.auditableBeanWrapperFactory.getBeanWrapperFor(source);
        long current = wrapper.getLastModifiedDate().getTimeInMillis() / 1000L * 1000L;
        return current <= headers.getIfModifiedSince();
    }

    private AuditableBeanWrapper getAuditableBeanWrapper(Object source) {
        return this.auditableBeanWrapperFactory.getBeanWrapperFor(source);
    }

    @ConstructorProperties(value={"auditableBeanWrapperFactory"})
    public HttpHeadersPreparer(@NonNull AuditableBeanWrapperFactory auditableBeanWrapperFactory) {
        if (auditableBeanWrapperFactory == null) {
            throw new IllegalArgumentException("auditableBeanWrapperFactory is null");
        }
        this.auditableBeanWrapperFactory = auditableBeanWrapperFactory;
    }
}

