/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import lombok.NonNull;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.SimplePropertyHandler;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.webmvc.json.MappedProperties;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.Assert;

public class DomainObjectReader {
    @NonNull
    private final PersistentEntities entities;
    @NonNull
    private final Associations associationLinks;

    public <T> T read(InputStream source, T target, ObjectMapper mapper) {
        Assert.notNull(target, (String)"Target object must not be null!");
        Assert.notNull((Object)source, (String)"InputStream must not be null!");
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        try {
            return this.doMerge((ObjectNode)mapper.readTree(source), target, mapper);
        }
        catch (Exception o_O) {
            throw new HttpMessageNotReadableException("Could not read payload!", (Throwable)o_O);
        }
    }

    public <T> T readPut(final ObjectNode source, T target, ObjectMapper mapper) {
        Assert.notNull((Object)source, (String)"ObjectNode must not be null!");
        Assert.notNull(target, (String)"Existing object instance must not be null!");
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        Class<?> type = target.getClass();
        PersistentEntity entity = this.entities.getPersistentEntity(type);
        Assert.notNull((Object)entity, (String)"No PersistentEntity found for ".concat(type.getName()).concat("!"));
        final MappedProperties properties = MappedProperties.fromJacksonProperties(entity, mapper);
        entity.doWithProperties(new SimplePropertyHandler(){

            public void doWithPersistentProperty(PersistentProperty<?> property) {
                boolean noValueInSource;
                if (property.isIdProperty() || property.isVersionProperty() || !property.isWritable()) {
                    return;
                }
                String mappedName = properties.getMappedName(property);
                boolean isMappedProperty = mappedName != null;
                boolean bl = noValueInSource = !source.has(mappedName);
                if (isMappedProperty && noValueInSource) {
                    source.putNull(mappedName);
                }
            }
        });
        return this.merge(source, target, mapper);
    }

    public <T> T merge(ObjectNode source, T target, ObjectMapper mapper) {
        try {
            return this.doMerge(source, target, mapper);
        }
        catch (Exception o_O) {
            throw new HttpMessageNotReadableException("Could not read payload!", (Throwable)o_O);
        }
    }

    private <T> T doMerge(ObjectNode root, T target, ObjectMapper mapper) throws Exception {
        Assert.notNull((Object)root, (String)"Root ObjectNode must not be null!");
        Assert.notNull(target, (String)"Target object instance must not be null!");
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        PersistentEntity entity = this.entities.getPersistentEntity(target.getClass());
        if (entity == null) {
            return (T)mapper.readerForUpdating(target).readValue((JsonNode)root);
        }
        MappedProperties mappedProperties = MappedProperties.fromJacksonProperties(entity, mapper);
        Iterator i = root.fields();
        while (i.hasNext()) {
            PersistentProperty<?> property;
            Map.Entry entry = (Map.Entry)i.next();
            JsonNode child = (JsonNode)entry.getValue();
            if (child.isArray()) continue;
            String fieldName = (String)entry.getKey();
            if (!mappedProperties.hasPersistentPropertyForField(fieldName)) {
                i.remove();
                continue;
            }
            if (!child.isObject() || this.associationLinks.isLinkableAssociation(property = mappedProperties.getPersistentProperty(fieldName))) continue;
            PersistentPropertyAccessor accessor = entity.getPropertyAccessor(target);
            Object nested = accessor.getProperty(property);
            ObjectNode objectNode = (ObjectNode)child;
            if (property.isMap()) {
                if (!objectNode.fieldNames().hasNext()) continue;
                this.doMergeNestedMap((Map)nested, objectNode, mapper);
                if (objectNode.fieldNames().hasNext()) continue;
                i.remove();
                continue;
            }
            if (nested == null || !property.isEntity()) continue;
            this.doMerge(objectNode, nested, mapper);
        }
        return (T)mapper.readerForUpdating(target).readValue((JsonNode)root);
    }

    private void doMergeNestedMap(Map<String, Object> source, ObjectNode node, ObjectMapper mapper) throws Exception {
        if (source == null) {
            return;
        }
        Iterator fields = node.fields();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            JsonNode child = (JsonNode)entry.getValue();
            Object sourceValue = source.get(entry.getKey());
            if (!(child instanceof ObjectNode) || sourceValue == null) continue;
            this.doMerge((ObjectNode)child, sourceValue, mapper);
            fields.remove();
        }
    }

    @ConstructorProperties(value={"entities", "associationLinks"})
    public DomainObjectReader(@NonNull PersistentEntities entities, @NonNull Associations associationLinks) {
        if (entities == null) {
            throw new IllegalArgumentException("entities is null");
        }
        if (associationLinks == null) {
            throw new IllegalArgumentException("associationLinks is null");
        }
        this.entities = entities;
        this.associationLinks = associationLinks;
    }
}

