/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.BasicClassIntrospector;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.util.Assert;

class MappedProperties {
    private static final ClassIntrospector INTROSPECTOR = new BasicClassIntrospector();
    private final Map<PersistentProperty<?>, String> propertyToFieldName = new HashMap();
    private final Map<String, PersistentProperty<?>> fieldNameToProperty = new HashMap();

    private MappedProperties(PersistentEntity<?, ?> entity, BeanDescription description) {
        for (BeanPropertyDefinition property : description.findProperties()) {
            PersistentProperty persistentProperty = entity.getPersistentProperty(property.getInternalName());
            this.propertyToFieldName.put(persistentProperty, property.getName());
            this.fieldNameToProperty.put(property.getName(), persistentProperty);
        }
    }

    public static MappedProperties fromJacksonProperties(PersistentEntity<?, ?> entity, ObjectMapper mapper) {
        BeanDescription description = INTROSPECTOR.forDeserialization(mapper.getDeserializationConfig(), mapper.constructType((Type)entity.getType()), (ClassIntrospector.MixInResolver)mapper.getDeserializationConfig());
        return new MappedProperties(entity, description);
    }

    public String getMappedName(PersistentProperty<?> property) {
        Assert.notNull(property, (String)"PersistentProperty must not be null!");
        return this.propertyToFieldName.get(property);
    }

    public boolean hasPersistentPropertyForField(String fieldName) {
        Assert.hasText((String)fieldName, (String)"Field name must not be null or empty!");
        return this.fieldNameToProperty.containsKey(fieldName);
    }

    public PersistentProperty<?> getPersistentProperty(String fieldName) {
        Assert.hasText((String)fieldName, (String)"Field name must not be null or empty!");
        return this.fieldNameToProperty.get(fieldName);
    }
}

