/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import org.springframework.core.MethodParameter;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.rest.core.projection.ProjectionDefinitions;
import org.springframework.data.rest.core.support.SelfLinkProvider;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.data.rest.webmvc.support.PersistentEntityProjector;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PersistentEntityResourceAssemblerArgumentResolver
implements HandlerMethodArgumentResolver {
    @NonNull
    private final PersistentEntities entities;
    @NonNull
    private final SelfLinkProvider linkProvider;
    @NonNull
    private final ProjectionDefinitions projectionDefinitions;
    @NonNull
    private final ProjectionFactory projectionFactory;
    @NonNull
    private final Associations links;

    public boolean supportsParameter(MethodParameter parameter) {
        return PersistentEntityResourceAssembler.class.equals((Object)parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        String projectionParameter = webRequest.getParameter(this.projectionDefinitions.getParameterName());
        PersistentEntityProjector projector = new PersistentEntityProjector(this.projectionDefinitions, this.projectionFactory, projectionParameter, this.links.getMappings());
        return new PersistentEntityResourceAssembler(this.entities, projector, this.links, this.linkProvider);
    }

    @ConstructorProperties(value={"entities", "linkProvider", "projectionDefinitions", "projectionFactory", "links"})
    public PersistentEntityResourceAssemblerArgumentResolver(@NonNull PersistentEntities entities, @NonNull SelfLinkProvider linkProvider, @NonNull ProjectionDefinitions projectionDefinitions, @NonNull ProjectionFactory projectionFactory, @NonNull Associations links) {
        if (entities == null) {
            throw new IllegalArgumentException("entities is null");
        }
        if (linkProvider == null) {
            throw new IllegalArgumentException("linkProvider is null");
        }
        if (projectionDefinitions == null) {
            throw new IllegalArgumentException("projectionDefinitions is null");
        }
        if (projectionFactory == null) {
            throw new IllegalArgumentException("projectionFactory is null");
        }
        if (links == null) {
            throw new IllegalArgumentException("links is null");
        }
        this.entities = entities;
        this.linkProvider = linkProvider;
        this.projectionDefinitions = projectionDefinitions;
        this.projectionFactory = projectionFactory;
        this.links = links;
    }
}

