/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.data.rest.core.config.JsonSchemaFormat;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.json.JacksonMetadata;
import org.springframework.data.rest.webmvc.json.JsonSchema;
import org.springframework.data.rest.webmvc.json.JsonSchemaPropertyCustomizer;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PersistentEntityToJsonSchemaConverter
implements ConditionalGenericConverter {
    private static final TypeDescriptor STRING_TYPE = TypeDescriptor.valueOf(String.class);
    private static final TypeDescriptor SCHEMA_TYPE = TypeDescriptor.valueOf(JsonSchema.class);
    private static final TypeInformation<?> STRING_TYPE_INFORMATION = ClassTypeInformation.from(String.class);
    private final Set<GenericConverter.ConvertiblePair> convertiblePairs = new HashSet<GenericConverter.ConvertiblePair>();
    private final Associations associations;
    private final PersistentEntities entities;
    private final MessageSourceAccessor accessor;
    private final ObjectMapper objectMapper;
    private final RepositoryRestConfiguration configuration;
    private final ValueTypeSchemaPropertyCustomizerFactory customizerFactory;

    public PersistentEntityToJsonSchemaConverter(PersistentEntities entities, Associations associations, MessageSourceAccessor accessor, ObjectMapper objectMapper, RepositoryRestConfiguration configuration, ValueTypeSchemaPropertyCustomizerFactory customizerFactory) {
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null!");
        Assert.notNull((Object)associations, (String)"AssociationLinks must not be null!");
        Assert.notNull((Object)accessor, (String)"MessageSourceAccessor must not be null!");
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null!");
        Assert.notNull((Object)configuration, (String)"RepositoryRestConfiguration must not be null!");
        this.entities = entities;
        this.associations = associations;
        this.accessor = accessor;
        this.objectMapper = objectMapper;
        this.configuration = configuration;
        this.customizerFactory = customizerFactory;
        for (TypeInformation domainType : entities.getManagedTypes()) {
            this.convertiblePairs.add(new GenericConverter.ConvertiblePair(domainType.getType(), JsonSchema.class));
        }
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return Class.class.isAssignableFrom(sourceType.getType()) && JsonSchema.class.isAssignableFrom(targetType.getType());
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return this.convertiblePairs;
    }

    public JsonSchema convert(Class<?> domainType) {
        return this.convert(domainType, STRING_TYPE, SCHEMA_TYPE);
    }

    public JsonSchema convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        PersistentEntity persistentEntity = this.entities.getPersistentEntity((Class)source);
        ResourceMetadata metadata = this.associations.getMappings().getMetadataFor(persistentEntity.getType());
        JsonSchema.Definitions definitions = new JsonSchema.Definitions();
        List<JsonSchema.AbstractJsonSchemaProperty<?>> propertiesFor = this.getPropertiesFor(persistentEntity.getType(), metadata, definitions);
        String title = this.resolveMessageWithDefault((MessageSourceResolvable)new ResolvableType(persistentEntity.getType()));
        return new JsonSchema(title, this.resolveMessage((MessageSourceResolvable)metadata.getItemResourceDescription()), propertiesFor, definitions);
    }

    private List<JsonSchema.AbstractJsonSchemaProperty<?>> getPropertiesFor(Class<?> type, ResourceMetadata metadata, JsonSchema.Definitions definitions) {
        PersistentEntity entity = this.entities.getPersistentEntity(type);
        JacksonMetadata jackson = new JacksonMetadata(this.objectMapper, type);
        if (entity == null) {
            return Collections.emptyList();
        }
        JsonSchemaPropertyRegistrar registrar = new JsonSchemaPropertyRegistrar(jackson);
        for (BeanPropertyDefinition definition : jackson) {
            boolean isJacksonReadOnly;
            AnnotatedMember primaryMember;
            PersistentProperty persistentProperty = entity.getPersistentProperty(definition.getInternalName());
            if (persistentProperty != null && (persistentProperty.isIdProperty() && !this.configuration.isIdExposedFor(type) || persistentProperty.isVersionProperty() || !definition.couldSerialize()) || (primaryMember = definition.getPrimaryMember()) == null) continue;
            TypeInformation propertyType = persistentProperty == null ? ClassTypeInformation.from((Class)primaryMember.getRawType()) : persistentProperty.getTypeInformation();
            TypeInformation actualPropertyType = propertyType.getActualType();
            Class rawPropertyType = propertyType.getType();
            JsonSchemaFormat format = this.configuration.getMetadataConfiguration().getSchemaFormatFor(rawPropertyType);
            ResourceDescription description = persistentProperty == null ? jackson.getFallbackDescription(metadata, definition) : this.getDescriptionFor(persistentProperty, metadata);
            JsonSchema.JsonSchemaProperty property = this.getSchemaProperty(definition, propertyType, description);
            boolean isSyntheticProperty = persistentProperty == null;
            boolean isNotWritable = !isSyntheticProperty && !persistentProperty.isWritable();
            boolean bl = isJacksonReadOnly = !isSyntheticProperty && jackson.isReadOnly(persistentProperty);
            if (isSyntheticProperty || isNotWritable || isJacksonReadOnly) {
                property = (JsonSchema.JsonSchemaProperty)property.withReadOnly();
            }
            if (format != null) {
                registrar.register(property.withFormat(format), actualPropertyType);
                continue;
            }
            Pattern pattern = this.configuration.getMetadataConfiguration().getPatternFor(rawPropertyType);
            if (pattern != null) {
                registrar.register(property.withPattern(pattern), actualPropertyType);
                continue;
            }
            if (jackson.isValueType()) {
                registrar.register(property.with(STRING_TYPE_INFORMATION), actualPropertyType);
                continue;
            }
            if (persistentProperty == null) {
                registrar.register(property, actualPropertyType);
                continue;
            }
            if (this.configuration.isLookupType(persistentProperty.getActualType())) {
                registrar.register(property.with(propertyType), actualPropertyType);
                continue;
            }
            if (this.associations.isLinkableAssociation(persistentProperty)) {
                registrar.register(property.asAssociation(), null);
                continue;
            }
            if (persistentProperty.isEntity()) {
                if (!definitions.hasDefinitionFor(propertyType)) {
                    definitions.addDefinition(propertyType, new JsonSchema.Item(propertyType, this.getNestedPropertiesFor(persistentProperty, definitions)));
                }
                registrar.register(property.with(propertyType, JsonSchema.Definitions.getReference(propertyType)), actualPropertyType);
                continue;
            }
            registrar.register(property.with(propertyType), actualPropertyType);
        }
        return registrar.getProperties();
    }

    private Collection<JsonSchema.AbstractJsonSchemaProperty<?>> getNestedPropertiesFor(PersistentProperty<?> property, JsonSchema.Definitions descriptors) {
        if (!property.isEntity()) {
            return Collections.emptyList();
        }
        return this.getPropertiesFor(property.getActualType(), this.associations.getMappings().getMetadataFor(property.getActualType()), descriptors);
    }

    private JsonSchema.JsonSchemaProperty getSchemaProperty(BeanPropertyDefinition definition, TypeInformation<?> type, ResourceDescription description) {
        String name = definition.getName();
        String title = this.resolveMessageWithDefault((MessageSourceResolvable)new ResolvableProperty(definition));
        String resolvedDescription = this.resolveMessage((MessageSourceResolvable)description);
        boolean required = definition.isRequired();
        Class rawType = type.getType();
        if (!rawType.isEnum()) {
            return new JsonSchema.JsonSchemaProperty(name, title, resolvedDescription, required).with(type);
        }
        String message = this.resolveMessage((MessageSourceResolvable)new DefaultMessageSourceResolvable(description.getMessage()));
        return new JsonSchema.EnumProperty(name, title, rawType, description.getDefaultMessage().equals(resolvedDescription) ? message : resolvedDescription, required);
    }

    private ResourceDescription getDescriptionFor(PersistentProperty<?> property, ResourceMetadata metadata) {
        ResourceMapping propertyMapping = metadata.getMappingFor(property);
        return propertyMapping.getDescription();
    }

    private String resolveMessageWithDefault(MessageSourceResolvable resolvable) {
        return this.resolveMessage(new DefaultingMessageSourceResolvable(resolvable));
    }

    private String resolveMessage(MessageSourceResolvable resolvable) {
        if (resolvable == null) {
            return null;
        }
        try {
            return this.accessor.getMessage(resolvable);
        }
        catch (NoSuchMessageException o_O) {
            if (this.configuration.getMetadataConfiguration().omitUnresolvableDescriptionKeys()) {
                return null;
            }
            throw o_O;
        }
    }

    private static class ResolvableType
    extends DefaultMessageSourceResolvable {
        private static final long serialVersionUID = -7199875272753949857L;

        public ResolvableType(Class<?> type) {
            super(ResolvableType.getTitleCodes(type));
        }

        private static String[] getTitleCodes(Class<?> type) {
            Assert.notNull(type, (String)"Type must not be null!");
            return new String[]{type.getName().concat("._title"), type.getSimpleName().concat("._title")};
        }
    }

    private static class ResolvableProperty
    extends DefaultMessageSourceResolvable {
        private static final long serialVersionUID = -5603381674553244480L;

        public ResolvableProperty(BeanPropertyDefinition property) {
            super(ResolvableProperty.getCodes(property));
        }

        private static String[] getCodes(BeanPropertyDefinition property) {
            Assert.notNull((Object)property, (String)"BeanPropertyDefinition must not be null!");
            Class owner = property.getPrimaryMember().getDeclaringClass();
            String propertyTitle = property.getInternalName().concat("._title");
            String localName = owner.getSimpleName().concat(".").concat(propertyTitle);
            String fullName = owner.getName().concat(".").concat(propertyTitle);
            return new String[]{fullName, localName, propertyTitle};
        }
    }

    private static class DefaultingMessageSourceResolvable
    implements MessageSourceResolvable {
        private static Pattern SPLIT_CAMEL_CASE = Pattern.compile("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
        private final MessageSourceResolvable delegate;

        public DefaultingMessageSourceResolvable(MessageSourceResolvable delegate) {
            this.delegate = delegate;
        }

        public Object[] getArguments() {
            return this.delegate.getArguments();
        }

        public String[] getCodes() {
            return this.delegate.getCodes();
        }

        public String getDefaultMessage() {
            String defaultMessage = this.delegate.getDefaultMessage();
            if (defaultMessage != null) {
                return defaultMessage;
            }
            String[] split = this.getCodes()[0].split("\\.");
            String tail = split[split.length - 1];
            tail = "_title".equals(tail) ? split[split.length - 2] : tail;
            return StringUtils.capitalize((String)StringUtils.collectionToDelimitedString(Arrays.asList(SPLIT_CAMEL_CASE.split(tail)), (String)" ").toLowerCase(Locale.US));
        }
    }

    public static class ValueTypeSchemaPropertyCustomizerFactory {
        @NonNull
        private final RepositoryInvokerFactory factory;

        public JsonSchemaPropertyCustomizer getCustomizerFor(Class<?> type) {
            return new JsonSchemaPropertyCustomizer(){

                @Override
                public JsonSchema.JsonSchemaProperty customize(JsonSchema.JsonSchemaProperty property, TypeInformation<?> type) {
                    ArrayList<String> result = new ArrayList<String>();
                    for (Object element : ValueTypeSchemaPropertyCustomizerFactory.this.factory.getInvokerFor(type.getType()).invokeFindAll((Sort)null)) {
                        result.add(element.toString());
                    }
                    Collections.sort(result);
                    return new JsonSchema.EnumProperty(property.getName(), property.getTitle(), result, property.description, true);
                }
            };
        }

        public ValueTypeSchemaPropertyCustomizerFactory(@NonNull RepositoryInvokerFactory factory) {
            if (factory == null) {
                throw new IllegalArgumentException("factory is marked @NonNull but is null");
            }
            this.factory = factory;
        }
    }

    private class JsonSchemaPropertyRegistrar {
        private final JacksonMetadata metadata;
        private final List<JsonSchema.AbstractJsonSchemaProperty<?>> properties;

        public JsonSchemaPropertyRegistrar(JacksonMetadata metadata) {
            Assert.notNull((Object)metadata, (String)"Metadata must not be null!");
            this.metadata = metadata;
            this.properties = new ArrayList();
        }

        public void register(JsonSchema.JsonSchemaProperty property, TypeInformation<?> type) {
            if (type == null) {
                this.properties.add(property);
                return;
            }
            JsonSerializer<?> serializer = this.metadata.getTypeSerializer(type.getType());
            if (serializer instanceof JsonSchemaPropertyCustomizer) {
                this.properties.add(((JsonSchemaPropertyCustomizer)serializer).customize(property, type));
                return;
            }
            if (PersistentEntityToJsonSchemaConverter.this.configuration.isLookupType(type.getType())) {
                this.properties.add(PersistentEntityToJsonSchemaConverter.this.customizerFactory.getCustomizerFor(type.getType()).customize(property, type));
                return;
            }
            this.properties.add(property);
        }

        public List<JsonSchema.AbstractJsonSchemaProperty<?>> getProperties() {
            return this.properties;
        }
    }
}

