/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.alps;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.SimplePropertyHandler;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.annotation.Description;
import org.springframework.data.rest.core.config.ProjectionDefinitionConfiguration;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.AnnotationBasedResourceDescription;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.data.rest.core.mapping.ParameterMetadata;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.ResourceType;
import org.springframework.data.rest.core.mapping.SimpleResourceDescription;
import org.springframework.data.rest.core.mapping.SupportedHttpMethods;
import org.springframework.data.rest.webmvc.ProfileController;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.rest.webmvc.json.EnumTranslator;
import org.springframework.data.rest.webmvc.json.JacksonMetadata;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.alps.Alps;
import org.springframework.hateoas.alps.Descriptor;
import org.springframework.hateoas.alps.Doc;
import org.springframework.hateoas.alps.Format;
import org.springframework.hateoas.alps.Type;
import org.springframework.http.HttpMethod;
import org.springframework.util.StringUtils;

public class RootResourceInformationToAlpsDescriptorConverter {
    private static final List<HttpMethod> UNDOCUMENTED_METHODS = Arrays.asList(HttpMethod.OPTIONS, HttpMethod.HEAD);
    @NonNull
    private final Associations associations;
    @NonNull
    private final Repositories repositories;
    @NonNull
    private final PersistentEntities persistentEntities;
    @NonNull
    private final EntityLinks entityLinks;
    @NonNull
    private final MessageSourceAccessor messageSource;
    @NonNull
    private final RepositoryRestConfiguration configuration;
    @NonNull
    private final ObjectMapper mapper;
    @NonNull
    private final EnumTranslator translator;

    public Alps convert(RootResourceInformation resourceInformation) {
        Class<?> type = resourceInformation.getDomainType();
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
        Descriptor representationDescriptor = this.buildRepresentationDescriptor(type);
        descriptors.add(representationDescriptor);
        SupportedHttpMethods supportedHttpMethods = resourceInformation.getSupportedMethods();
        for (HttpMethod method : supportedHttpMethods.getMethodsFor(ResourceType.COLLECTION)) {
            if (UNDOCUMENTED_METHODS.contains(method)) continue;
            descriptors.add(this.buildCollectionResourceDescriptor(type, resourceInformation, representationDescriptor, method));
        }
        for (HttpMethod method : supportedHttpMethods.getMethodsFor(ResourceType.ITEM)) {
            if (UNDOCUMENTED_METHODS.contains(method)) continue;
            descriptors.add(this.buildItemResourceDescriptor(resourceInformation, representationDescriptor, method));
        }
        descriptors.addAll(this.buildSearchResourceDescriptors(resourceInformation.getPersistentEntity()));
        return Alps.alps().descriptors(descriptors).build();
    }

    private Descriptor buildRepresentationDescriptor(Class<?> type) {
        ResourceMetadata metadata = this.associations.getMetadataFor(type);
        String href = ProfileController.getPath(this.configuration, (ResourceMapping)metadata);
        return Alps.descriptor().id(RootResourceInformationToAlpsDescriptorConverter.getRepresentationDescriptorId(metadata)).href(href).doc(this.getDocFor(metadata.getItemResourceDescription())).descriptors(this.buildPropertyDescriptors(type, metadata.getItemResourceRel())).build();
    }

    private Descriptor buildCollectionResourceDescriptor(Class<?> type, RootResourceInformation resourceInformation, Descriptor representationDescriptor, HttpMethod method) {
        ResourceMetadata metadata = this.associations.getMetadataFor(type);
        ArrayList<Descriptor> nestedDescriptors = new ArrayList<Descriptor>();
        nestedDescriptors.addAll(this.getPaginationDescriptors(type, method));
        nestedDescriptors.addAll(this.getProjectionDescriptor(type, method));
        Type descriptorType = RootResourceInformationToAlpsDescriptorConverter.getType(method);
        return Alps.descriptor().id(RootResourceInformationToAlpsDescriptorConverter.prefix(method).concat(metadata.getRel())).name(metadata.getRel()).type(descriptorType).doc(this.getDocFor(metadata.getDescription())).rt("#" + representationDescriptor.getId()).descriptors(nestedDescriptors).build();
    }

    private Descriptor buildProjectionDescriptor(ResourceMetadata metadata) {
        ProjectionDefinitionConfiguration projectionConfiguration = this.configuration.getProjectionConfiguration();
        String projectionParameterName = projectionConfiguration.getParameterName();
        Map projections = projectionConfiguration.getProjectionsFor(metadata.getDomainType());
        ArrayList<Descriptor> projectionDescriptors = new ArrayList<Descriptor>(projections.size());
        for (Map.Entry projection : projections.entrySet()) {
            Class type = (Class)projection.getValue();
            String key = String.format("%s.%s.%s", metadata.getRel(), projectionParameterName, projection.getKey());
            ResourceDescription fallback = SimpleResourceDescription.defaultFor((String)key);
            AnnotationBasedResourceDescription projectionDescription = new AnnotationBasedResourceDescription(type, fallback);
            projectionDescriptors.add(Alps.descriptor().type(Type.SEMANTIC).name((String)projection.getKey()).doc(this.getDocFor((ResourceDescription)projectionDescription)).descriptors(this.createJacksonDescriptor((String)projection.getKey(), type)).build());
        }
        return Alps.descriptor().type(Type.SEMANTIC).name(projectionParameterName).doc(this.getDocFor(SimpleResourceDescription.defaultFor((String)projectionParameterName))).descriptors(projectionDescriptors).build();
    }

    private List<Descriptor> createJacksonDescriptor(String name, Class<?> type) {
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
        for (BeanPropertyDefinition definition : new JacksonMetadata(this.mapper, type)) {
            AnnotatedMethod getter = definition.getGetter();
            Description description = (Description)getter.getAnnotation(Description.class);
            ResourceDescription fallback = SimpleResourceDescription.defaultFor((String)String.format("%s.%s", name, definition.getName()));
            AnnotationBasedResourceDescription resourceDescription = description == null ? null : new AnnotationBasedResourceDescription(description, fallback);
            descriptors.add(Alps.descriptor().name(definition.getName()).type(Type.SEMANTIC).doc(this.getDocFor((ResourceDescription)resourceDescription)).build());
        }
        return descriptors;
    }

    private Descriptor buildItemResourceDescriptor(RootResourceInformation resourceInformation, Descriptor representationDescriptor, HttpMethod method) {
        PersistentEntity<?, ?> entity = resourceInformation.getPersistentEntity();
        ResourceMetadata metadata = this.associations.getMetadataFor(entity.getType());
        return Alps.descriptor().id(RootResourceInformationToAlpsDescriptorConverter.prefix(method).concat(metadata.getItemResourceRel())).name(metadata.getItemResourceRel()).type(RootResourceInformationToAlpsDescriptorConverter.getType(method)).doc(this.getDocFor(metadata.getItemResourceDescription())).rt("#".concat(representationDescriptor.getId())).descriptors(this.getProjectionDescriptor(entity.getType(), method)).build();
    }

    private List<Descriptor> getProjectionDescriptor(Class<?> type, HttpMethod method) {
        if (!Type.SAFE.equals((Object)RootResourceInformationToAlpsDescriptorConverter.getType(method))) {
            return Collections.emptyList();
        }
        ProjectionDefinitionConfiguration projectionConfiguration = this.configuration.getProjectionConfiguration();
        return projectionConfiguration.hasProjectionFor(type) ? Arrays.asList(this.buildProjectionDescriptor(this.associations.getMetadataFor(type))) : Collections.emptyList();
    }

    private List<Descriptor> getPaginationDescriptors(Class<?> type, HttpMethod method) {
        RepositoryInformation information = this.repositories.getRequiredRepositoryInformation(type);
        if (!information.isPagingRepository() || !RootResourceInformationToAlpsDescriptorConverter.getType(method).equals((Object)Type.SAFE)) {
            return Collections.emptyList();
        }
        Link linkToCollectionResource = this.entityLinks.linkToCollectionResource(type);
        List variables = linkToCollectionResource.getVariables();
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>(variables.size());
        ProjectionDefinitionConfiguration projectionConfiguration = this.configuration.getProjectionConfiguration();
        for (TemplateVariable variable : variables) {
            if (projectionConfiguration.getParameterName().equals(variable.getName())) continue;
            ResourceDescription description = SimpleResourceDescription.defaultFor((String)variable.getDescription());
            descriptors.add(Alps.descriptor().name(variable.getName()).type(Type.SEMANTIC).doc(this.getDocFor(description)).build());
        }
        return descriptors;
    }

    private List<Descriptor> buildPropertyDescriptors(Class<?> type, String baseRel) {
        PersistentEntity entity = this.persistentEntities.getRequiredPersistentEntity(type);
        final ArrayList<Descriptor> propertyDescriptors = new ArrayList<Descriptor>();
        final JacksonMetadata jackson = new JacksonMetadata(this.mapper, type);
        final ResourceMetadata metadata = this.associations.getMetadataFor(entity.getType());
        entity.doWithProperties(new SimplePropertyHandler(){

            public void doWithPersistentProperty(PersistentProperty<?> property) {
                BeanPropertyDefinition propertyDefinition = jackson.getDefinitionFor(property);
                ResourceMapping propertyMapping = metadata.getMappingFor(property);
                if (propertyDefinition != null) {
                    if (property.isIdProperty() && !RootResourceInformationToAlpsDescriptorConverter.this.configuration.isIdExposedFor(property.getOwner().getType())) {
                        return;
                    }
                    propertyDescriptors.add(Alps.descriptor().type(Type.SEMANTIC).name(propertyDefinition.getName()).doc(RootResourceInformationToAlpsDescriptorConverter.this.getDocFor(propertyMapping.getDescription(), property)).build());
                }
            }
        });
        entity.doWithAssociations(new SimpleAssociationHandler(){

            public void doWithAssociation(Association<? extends PersistentProperty<?>> association) {
                PersistentProperty property = association.getInverse();
                if (!jackson.isExported(property) || !RootResourceInformationToAlpsDescriptorConverter.this.associations.isLinkableAssociation(property)) {
                    return;
                }
                ResourceMapping mapping = metadata.getMappingFor(property);
                Descriptor.DescriptorBuilder builder = Alps.descriptor().name(mapping.getRel()).doc(RootResourceInformationToAlpsDescriptorConverter.this.getDocFor(mapping.getDescription()));
                ResourceMetadata targetTypeMetadata = RootResourceInformationToAlpsDescriptorConverter.this.associations.getMetadataFor(property.getActualType());
                String href = ProfileController.getPath(RootResourceInformationToAlpsDescriptorConverter.this.configuration, (ResourceMapping)targetTypeMetadata) + "#" + RootResourceInformationToAlpsDescriptorConverter.getRepresentationDescriptorId(targetTypeMetadata);
                Link link = new Link(href).withSelfRel();
                builder.type(Type.SAFE).rt(link.getHref());
                propertyDescriptors.add(builder.build());
            }
        });
        return propertyDescriptors;
    }

    private Collection<Descriptor> buildSearchResourceDescriptors(PersistentEntity<?, ?> entity) {
        ResourceMetadata metadata = this.associations.getMetadataFor(entity.getType());
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
        for (MethodResourceMapping methodMapping : metadata.getSearchResourceMappings()) {
            ArrayList<Descriptor> parameterDescriptors = new ArrayList<Descriptor>();
            for (ParameterMetadata parameterMetadata : methodMapping.getParametersMetadata()) {
                parameterDescriptors.add(Alps.descriptor().name(parameterMetadata.getName()).doc(this.getDocFor(parameterMetadata.getDescription())).type(Type.SEMANTIC).build());
            }
            descriptors.add(Alps.descriptor().type(Type.SAFE).name(methodMapping.getRel()).descriptors(parameterDescriptors).build());
        }
        return descriptors;
    }

    private Doc getDocFor(ResourceDescription description) {
        return this.getDocFor(description, null);
    }

    private Doc getDocFor(ResourceDescription description, PersistentProperty<?> property) {
        if (description == null) {
            return null;
        }
        String message = this.resolveMessage(description);
        if (this.configuration.isEnableEnumTranslation() && property != null && property.getType().isEnum() && description.isDefault()) {
            return new Doc(StringUtils.collectionToDelimitedString(this.translator.getValues(property.getType()), (String)", "), Format.TEXT);
        }
        return message == null ? null : new Doc(message, Format.TEXT);
    }

    private String resolveMessage(ResourceDescription description) {
        if (!description.isDefault()) {
            return description.getMessage();
        }
        try {
            return this.messageSource.getMessage((MessageSourceResolvable)description);
        }
        catch (NoSuchMessageException o_O) {
            return this.configuration.getMetadataConfiguration().omitUnresolvableDescriptionKeys() ? null : description.getMessage();
        }
    }

    private static String getRepresentationDescriptorId(ResourceMetadata metadata) {
        return metadata.getItemResourceRel().concat("-representation");
    }

    private static String prefix(HttpMethod method) {
        switch (method) {
            case GET: {
                return "get-";
            }
            case POST: {
                return "create-";
            }
            case DELETE: {
                return "delete-";
            }
            case PUT: {
                return "update-";
            }
            case PATCH: {
                return "patch-";
            }
        }
        throw new IllegalArgumentException(method.name());
    }

    private static Type getType(HttpMethod method) {
        switch (method) {
            case GET: {
                return Type.SAFE;
            }
            case DELETE: 
            case PUT: {
                return Type.IDEMPOTENT;
            }
            case POST: 
            case PATCH: {
                return Type.UNSAFE;
            }
        }
        return null;
    }

    public RootResourceInformationToAlpsDescriptorConverter(@NonNull Associations associations, @NonNull Repositories repositories, @NonNull PersistentEntities persistentEntities, @NonNull EntityLinks entityLinks, @NonNull MessageSourceAccessor messageSource, @NonNull RepositoryRestConfiguration configuration, @NonNull ObjectMapper mapper, @NonNull EnumTranslator translator) {
        if (associations == null) {
            throw new IllegalArgumentException("associations is marked non-null but is null");
        }
        if (repositories == null) {
            throw new IllegalArgumentException("repositories is marked non-null but is null");
        }
        if (persistentEntities == null) {
            throw new IllegalArgumentException("persistentEntities is marked non-null but is null");
        }
        if (entityLinks == null) {
            throw new IllegalArgumentException("entityLinks is marked non-null but is null");
        }
        if (messageSource == null) {
            throw new IllegalArgumentException("messageSource is marked non-null but is null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is marked non-null but is null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("mapper is marked non-null but is null");
        }
        if (translator == null) {
            throw new IllegalArgumentException("translator is marked non-null but is null");
        }
        this.associations = associations;
        this.repositories = repositories;
        this.persistentEntities = persistentEntities;
        this.entityLinks = entityLinks;
        this.messageSource = messageSource;
        this.configuration = configuration;
        this.mapper = mapper;
        this.translator = translator;
    }
}

