/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import java.io.Serializable;
import org.springframework.core.MethodParameter;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.util.Java8PluginRegistry;
import org.springframework.data.rest.webmvc.BaseUri;
import org.springframework.data.rest.webmvc.config.ResourceMetadataHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.spi.BackendIdConverter;
import org.springframework.data.rest.webmvc.support.BackendId;
import org.springframework.data.rest.webmvc.util.UriUtils;
import org.springframework.util.Assert;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class BackendIdHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final Java8PluginRegistry<BackendIdConverter, Class<?>> idConverters;
    private final ResourceMetadataHandlerMethodArgumentResolver resourceMetadataResolver;
    private final BaseUri baseUri;

    public BackendIdHandlerMethodArgumentResolver(Java8PluginRegistry<BackendIdConverter, Class<?>> idConverters, ResourceMetadataHandlerMethodArgumentResolver resourceMetadataResolver, BaseUri baseUri) {
        Assert.notNull(idConverters, (String)"Id converters must not be null!");
        Assert.notNull((Object)resourceMetadataResolver, (String)"ResourceMetadata resolver must not be null!");
        Assert.notNull((Object)baseUri, (String)"BaseUri must not be null!");
        this.idConverters = idConverters;
        this.resourceMetadataResolver = resourceMetadataResolver;
        this.baseUri = baseUri;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(BackendId.class);
    }

    public Serializable resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest request, WebDataBinderFactory binderFactory) throws Exception {
        Class parameterType = parameter.getParameterType();
        if (parameter.getMethodAnnotation(BackendId.class) != null && !parameterType.equals(Serializable.class)) {
            throw new IllegalArgumentException(String.format("Method parameter for @%s must be of type %s! Got %s for method %s.", BackendId.class.getSimpleName(), Serializable.class.getSimpleName(), parameterType.getSimpleName(), parameter.getMethod()));
        }
        ResourceMetadata metadata = this.resourceMetadataResolver.resolveArgument(parameter, mavContainer, request, binderFactory);
        if (metadata == null) {
            throw new IllegalArgumentException("Could not obtain ResourceMetadata for request " + request);
        }
        BackendIdConverter pluginFor = this.idConverters.getPluginFor((Object)metadata.getDomainType()).orElse(BackendIdConverter.DefaultIdConverter.INSTANCE);
        String lookupPath = this.baseUri.getRepositoryLookupPath(request);
        return pluginFor.fromRequestId(UriUtils.findMappingVariable("id", parameter.getMethod(), lookupPath), metadata.getDomainType());
    }
}

