/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json.patch;

import org.springframework.data.rest.webmvc.json.patch.PatchOperation;
import org.springframework.data.rest.webmvc.json.patch.SpelPath;

class CopyOperation
extends PatchOperation {
    private final SpelPath.UntypedSpelPath from;

    public CopyOperation(SpelPath.UntypedSpelPath path, SpelPath.UntypedSpelPath from) {
        super("copy", path);
        this.from = from;
    }

    public static CopyOperationBuilder from(String from) {
        return new CopyOperationBuilder(from);
    }

    @Override
    void perform(Object target, Class<?> type) {
        this.path.bindTo(type).copyFrom(this.from, target);
    }

    static class CopyOperationBuilder {
        private final String from;

        CopyOperation to(String to) {
            return new CopyOperation(SpelPath.untyped(to), SpelPath.untyped(this.from));
        }

        public CopyOperationBuilder(String from) {
            this.from = from;
        }
    }
}

