/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.CollectionFactory;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.data.rest.core.event.AfterLinkDeleteEvent;
import org.springframework.data.rest.core.event.AfterLinkSaveEvent;
import org.springframework.data.rest.core.event.BeforeLinkDeleteEvent;
import org.springframework.data.rest.core.event.BeforeLinkSaveEvent;
import org.springframework.data.rest.core.mapping.PropertyAwareResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.AbstractRepositoryRestController;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.rest.webmvc.RestMediaTypes;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.rest.webmvc.support.BackendId;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;

@RepositoryRestController
class RepositoryPropertyReferenceController
extends AbstractRepositoryRestController
implements ApplicationEventPublisherAware {
    private static final String BASE_MAPPING = "/{repository}/{id}/{property}";
    private static final Collection<HttpMethod> AUGMENTING_METHODS = Arrays.asList(HttpMethod.PATCH, HttpMethod.POST);
    private final Repositories repositories;
    private final RepositoryInvokerFactory repositoryInvokerFactory;
    private ApplicationEventPublisher publisher;

    @Autowired
    public RepositoryPropertyReferenceController(Repositories repositories, RepositoryInvokerFactory repositoryInvokerFactory, PagedResourcesAssembler<Object> assembler) {
        super(assembler);
        this.repositories = repositories;
        this.repositoryInvokerFactory = repositoryInvokerFactory;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.GET})
    public ResponseEntity<RepresentationModel<?>> followPropertyReference(RootResourceInformation repoRequest, @BackendId Serializable id, @PathVariable String property, PersistentEntityResourceAssembler assembler) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        Function<ReferencedProperty, RepresentationModel<?>> handler = prop -> prop.mapValue(it -> {
            if (prop.property.isCollectionLike()) {
                return this.toCollectionModel((Iterable)it, assembler, prop.propertyType, Optional.empty());
            }
            if (prop.property.isMap()) {
                return ((Map)it).entrySet().stream().collect(Collectors.collectingAndThen(Collectors.toMap(Map.Entry::getKey, entry -> assembler.toModel(entry.getValue())), x$0 -> new MapModel((Map<? extends Object, ? extends Object>)x$0, new Link[0])));
            }
            PersistentEntityResource resource = assembler.toModel(it);
            headers.set("Content-Location", resource.getRequiredLink(IanaLinkRelations.SELF).getHref());
            return resource;
        }).orElseThrow(ResourceNotFoundException::new);
        return ControllerUtils.toResponseEntity(HttpStatus.OK, headers, this.doWithReferencedProperty(repoRequest, id, property, handler, HttpMethod.GET));
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.DELETE})
    public ResponseEntity<? extends RepresentationModel<?>> deletePropertyReference(RootResourceInformation repoRequest, @BackendId Serializable id, @PathVariable String property) throws Exception {
        Function<ReferencedProperty, RepresentationModel<?>> handler = prop -> prop.mapValue(it -> {
            if (prop.property.isCollectionLike() || prop.property.isMap()) {
                throw HttpRequestMethodNotSupportedException.forRejectedMethod(HttpMethod.DELETE).withAllowedMethods(HttpMethod.GET, HttpMethod.HEAD);
            }
            prop.wipeValue();
            this.publisher.publishEvent((ApplicationEvent)new BeforeLinkDeleteEvent(prop.accessor.getBean(), prop.propertyValue));
            Object result = repoRequest.getInvoker().invokeSave(prop.accessor.getBean());
            this.publisher.publishEvent((ApplicationEvent)new AfterLinkDeleteEvent(result, prop.propertyValue));
            return null;
        }).orElse(null);
        this.doWithReferencedProperty(repoRequest, id, property, handler, HttpMethod.DELETE);
        return ControllerUtils.toEmptyResponse(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/{repository}/{id}/{property}/{propertyId}"}, method={RequestMethod.GET})
    public ResponseEntity<RepresentationModel<?>> followPropertyReference(RootResourceInformation repoRequest, @BackendId Serializable id, @PathVariable String property, @PathVariable String propertyId, PersistentEntityResourceAssembler assembler) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        Function<ReferencedProperty, RepresentationModel<?>> handler = prop -> prop.mapValue(it -> {
            if (prop.property.isCollectionLike()) {
                for (Object obj : (Iterable)it) {
                    IdentifierAccessor accessor1 = prop.entity.getIdentifierAccessor(obj);
                    if (!propertyId.equals(accessor1.getIdentifier().toString())) continue;
                    PersistentEntityResource resource1 = assembler.toModel(obj);
                    headers.set("Content-Location", resource1.getRequiredLink(IanaLinkRelations.SELF).getHref());
                    return resource1;
                }
            } else if (prop.property.isMap()) {
                for (Map.Entry entry : ((Map)it).entrySet()) {
                    IdentifierAccessor accessor2 = prop.entity.getIdentifierAccessor(entry.getValue());
                    if (!propertyId.equals(accessor2.getIdentifier().toString())) continue;
                    PersistentEntityResource resource2 = assembler.toModel(entry.getValue());
                    headers.set("Content-Location", resource2.getRequiredLink(IanaLinkRelations.SELF).getHref());
                    return resource2;
                }
            } else {
                return new EntityModel(prop.propertyValue, new Link[0]);
            }
            throw new ResourceNotFoundException();
        }).orElseThrow(ResourceNotFoundException::new);
        return ControllerUtils.toResponseEntity(HttpStatus.OK, headers, this.doWithReferencedProperty(repoRequest, id, property, handler, HttpMethod.GET));
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.GET}, produces={"text/uri-list"})
    public ResponseEntity<RepresentationModel<?>> followPropertyReferenceCompact(RootResourceInformation repoRequest, @BackendId Serializable id, @PathVariable String property, @RequestHeader HttpHeaders requestHeaders, PersistentEntityResourceAssembler assembler) throws Exception {
        Function<ReferencedProperty, RepresentationModel<?>> handler = prop -> prop.mapValue(it -> {
            if (prop.property.isCollectionLike()) {
                Links links = (Links)((Collection)it).stream().map(assembler::getExpandedSelfLink).collect(Links.collector());
                return new RepresentationModel(links.toList());
            }
            if (prop.property.isMap()) {
                throw new UnsupportedMediaTypeStatusException("Cannot produce compact representation of map property!");
            }
            return new RepresentationModel(assembler.getExpandedSelfLink(it));
        }).orElse(new RepresentationModel());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(RestMediaTypes.TEXT_URI_LIST);
        return ControllerUtils.toResponseEntity(HttpStatus.OK, headers, this.doWithReferencedProperty(repoRequest, id, property, handler, HttpMethod.GET));
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.PATCH, RequestMethod.PUT, RequestMethod.POST}, consumes={"application/json", "application/x-spring-data-compact+json", "text/uri-list"})
    public ResponseEntity<? extends RepresentationModel<?>> createPropertyReference(RootResourceInformation resourceInformation, HttpMethod requestMethod, @RequestBody(required=false) CollectionModel<Object> incoming, @BackendId Serializable id, @PathVariable String property) throws Exception {
        CollectionModel source = incoming == null ? new CollectionModel(Collections.emptyList(), new Link[0]) : incoming;
        RepositoryInvoker invoker = resourceInformation.getInvoker();
        Function<ReferencedProperty, RepresentationModel<?>> handler = prop -> {
            Class propertyType = prop.property.getType();
            if (prop.property.isCollectionLike()) {
                Collection collection = AUGMENTING_METHODS.contains(requestMethod) ? (Collection)prop.propertyValue : CollectionFactory.createCollection((Class)propertyType, (int)0);
                for (Link l1 : source.getLinks()) {
                    collection.add(this.loadPropertyValue(prop.propertyType, l1));
                }
                prop.accessor.setProperty(prop.property, (Object)collection);
            } else if (prop.property.isMap()) {
                Map map = AUGMENTING_METHODS.contains(requestMethod) ? (Map)prop.propertyValue : CollectionFactory.createMap((Class)propertyType, (int)0);
                for (Link l2 : source.getLinks()) {
                    map.put(l2.getRel(), this.loadPropertyValue(prop.propertyType, l2));
                }
                prop.accessor.setProperty(prop.property, (Object)map);
            } else {
                if (HttpMethod.PATCH.equals((Object)requestMethod)) {
                    throw HttpRequestMethodNotSupportedException.forRejectedMethod(HttpMethod.PATCH).withAllowedMethods(HttpMethod.PATCH).withMessage("Cannot PATCH a reference to this singular property since the property type is not a List or a Map.", new Object[0]);
                }
                if (!source.getLinks().hasSingleLink()) {
                    throw new IllegalArgumentException("Must send only 1 link to update a property reference that isn't a List or a Map.");
                }
                prop.accessor.setProperty(prop.property, this.loadPropertyValue(prop.propertyType, (Link)source.getLinks().toList().get(0)));
            }
            this.publisher.publishEvent((ApplicationEvent)new BeforeLinkSaveEvent(prop.accessor.getBean(), prop.propertyValue));
            Object result = invoker.invokeSave(prop.accessor.getBean());
            this.publisher.publishEvent((ApplicationEvent)new AfterLinkSaveEvent(result, prop.propertyValue));
            return null;
        };
        this.doWithReferencedProperty(resourceInformation, id, property, handler, requestMethod);
        return ControllerUtils.toEmptyResponse(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/{repository}/{id}/{property}/{propertyId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<RepresentationModel<?>> deletePropertyReferenceId(RootResourceInformation repoRequest, @BackendId Serializable backendId, @PathVariable String property, @PathVariable String propertyId) throws Exception {
        Function<ReferencedProperty, RepresentationModel<?>> handler = prop -> prop.mapValue(it -> {
            if (prop.property.isCollectionLike()) {
                Collection coll = (Collection)it;
                Iterator iterator = coll.iterator();
                while (iterator.hasNext()) {
                    Object obj = iterator.next();
                    Optional.ofNullable(prop.entity.getIdentifierAccessor(obj).getIdentifier()).map(Object::toString).filter(id -> propertyId.equals(id)).ifPresent(__ -> iterator.remove());
                }
            } else if (prop.property.isMap()) {
                Map m = (Map)it;
                Iterator iterator = m.entrySet().iterator();
                while (iterator.hasNext()) {
                    Object key = iterator.next().getKey();
                    Optional.ofNullable(prop.entity.getIdentifierAccessor(m.get(key)).getIdentifier()).map(Object::toString).filter(id -> propertyId.equals(id)).ifPresent(__ -> iterator.remove());
                }
            } else {
                prop.wipeValue();
            }
            this.publisher.publishEvent((ApplicationEvent)new BeforeLinkDeleteEvent(prop.accessor.getBean(), it));
            Object result = repoRequest.getInvoker().invokeSave(prop.accessor.getBean());
            this.publisher.publishEvent((ApplicationEvent)new AfterLinkDeleteEvent(result, it));
            return null;
        }).orElse(null);
        this.doWithReferencedProperty(repoRequest, backendId, property, handler, HttpMethod.DELETE);
        return ControllerUtils.toEmptyResponse(HttpStatus.NO_CONTENT);
    }

    private Object loadPropertyValue(Class<?> type, Link link) {
        String href = link.expand(new Object[0]).getHref();
        String id = href.substring(href.lastIndexOf(47) + 1);
        RepositoryInvoker invoker = this.repositoryInvokerFactory.getInvokerFor(type);
        return invoker.invokeFindById((Object)id).orElse(null);
    }

    private Optional<RepresentationModel<?>> doWithReferencedProperty(RootResourceInformation resourceInformation, Serializable id, String propertyPath, Function<ReferencedProperty, RepresentationModel<?>> handler, HttpMethod method) throws Exception {
        ResourceMetadata metadata = resourceInformation.getResourceMetadata();
        PropertyAwareResourceMapping mapping = metadata.getProperty(propertyPath);
        if (mapping == null || !mapping.isExported()) {
            throw new ResourceNotFoundException();
        }
        PersistentProperty property = mapping.getProperty();
        resourceInformation.verifySupportedMethod(method, property);
        RepositoryInvoker invoker = resourceInformation.getInvoker();
        Optional domainObj = invoker.invokeFindById((Object)id);
        domainObj.orElseThrow(() -> new ResourceNotFoundException());
        return domainObj.map(it -> {
            PersistentPropertyAccessor accessor = property.getOwner().getPropertyAccessor(it);
            return (RepresentationModel)handler.apply(new ReferencedProperty(property, accessor.getProperty(property), accessor));
        });
    }

    @ExceptionHandler
    public ResponseEntity<Void> handle(HttpRequestMethodNotSupportedException exception) {
        return exception.toResponse();
    }

    static class HttpRequestMethodNotSupportedException
    extends RuntimeException {
        private static final long serialVersionUID = 3704212056962845475L;
        private final HttpMethod rejectedMethod;
        private final HttpMethod[] allowedMethods;
        private final String message;

        public static HttpRequestMethodNotSupportedException forRejectedMethod(HttpMethod method) {
            return new HttpRequestMethodNotSupportedException(method, new HttpMethod[0], null);
        }

        public HttpRequestMethodNotSupportedException withAllowedMethods(HttpMethod ... methods) {
            return new HttpRequestMethodNotSupportedException(this.rejectedMethod, (HttpMethod[])methods.clone(), null);
        }

        public HttpRequestMethodNotSupportedException withMessage(String message, Object ... parameters) {
            return new HttpRequestMethodNotSupportedException(this.rejectedMethod, this.allowedMethods, String.format(message, parameters));
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public ResponseEntity<Void> toResponse() {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).allow(this.allowedMethods)).build();
        }

        private HttpRequestMethodNotSupportedException(HttpMethod rejectedMethod, HttpMethod[] allowedMethods, String message) {
            this.rejectedMethod = rejectedMethod;
            this.allowedMethods = allowedMethods;
            this.message = message;
        }
    }

    private static class MapModel
    extends RepresentationModel<MapModel> {
        private Map<? extends Object, ? extends Object> content;

        public MapModel(Map<? extends Object, ? extends Object> content, Link ... links) {
            super(Arrays.asList(links));
            this.content = content;
        }

        @JsonAnyGetter
        public Map<? extends Object, ? extends Object> getContent() {
            return this.content;
        }
    }

    private class ReferencedProperty {
        final PersistentEntity<?, ?> entity;
        final PersistentProperty<?> property;
        final Class<?> propertyType;
        final Object propertyValue;
        final PersistentPropertyAccessor<?> accessor;

        private ReferencedProperty(PersistentProperty<?> property, Object propertyValue, PersistentPropertyAccessor<?> accessor) {
            this.property = property;
            this.propertyValue = propertyValue;
            this.accessor = accessor;
            this.propertyType = property.getActualType();
            this.entity = RepositoryPropertyReferenceController.this.repositories.getPersistentEntity(this.propertyType);
        }

        public void wipeValue() {
            this.accessor.setProperty(this.property, null);
        }

        public <T> Optional<T> mapValue(Function<Object, T> function) {
            return Optional.ofNullable(this.propertyValue).map(function);
        }
    }
}

