/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import lombok.NonNull;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.rest.webmvc.json.JacksonMappingAwareSortTranslator;
import org.springframework.data.rest.webmvc.support.DefaultedPageable;
import org.springframework.data.web.PageableHandlerMethodArgumentResolver;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class MappingAwareDefaultedPageableArgumentResolver
implements HandlerMethodArgumentResolver {
    @NonNull
    private final JacksonMappingAwareSortTranslator translator;
    @NonNull
    private final PageableHandlerMethodArgumentResolver delegate;

    public boolean supportsParameter(MethodParameter parameter) {
        return DefaultedPageable.class.isAssignableFrom(parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Pageable pageable = this.delegate.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        if (pageable == null || pageable.getSort() == null) {
            return new DefaultedPageable(pageable, this.delegate.isFallbackPageable(pageable));
        }
        Sort translated = this.translator.translateSort(pageable.getSort(), parameter, webRequest);
        pageable = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)translated);
        return new DefaultedPageable(pageable, this.delegate.isFallbackPageable(pageable));
    }

    public MappingAwareDefaultedPageableArgumentResolver(@NonNull JacksonMappingAwareSortTranslator translator, @NonNull PageableHandlerMethodArgumentResolver delegate) {
        if (translator == null) {
            throw new IllegalArgumentException("translator is marked non-null but is null");
        }
        if (delegate == null) {
            throw new IllegalArgumentException("delegate is marked non-null but is null");
        }
        this.translator = translator;
        this.delegate = delegate;
    }
}

