/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.time.Instant;
import java.util.Date;
import java.util.Optional;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.auditing.AuditableBeanWrapper;
import org.springframework.data.auditing.AuditableBeanWrapperFactory;
import org.springframework.data.convert.Jsr310Converters;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.support.ETag;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;

public class HttpHeadersPreparer {
    private final AuditableBeanWrapperFactory auditableBeanWrapperFactory;
    private final ConfigurableConversionService conversionService = new DefaultConversionService();

    public HttpHeadersPreparer(AuditableBeanWrapperFactory auditableBeanWrapperFactory) {
        Assert.notNull((Object)auditableBeanWrapperFactory, (String)"AuditableBeanWrapperFactory must not be null");
        Jsr310Converters.getConvertersToRegister().forEach(arg_0 -> ((ConfigurableConversionService)this.conversionService).addConverter(arg_0));
        this.auditableBeanWrapperFactory = auditableBeanWrapperFactory;
    }

    public HttpHeaders prepareHeaders(Optional<PersistentEntityResource> resource) {
        return resource.map(it -> this.prepareHeaders(it.getPersistentEntity(), it.getTarget())).orElseGet(() -> new HttpHeaders());
    }

    public HttpHeaders prepareHeaders(PersistentEntity<?, ?> entity, Object value) {
        Assert.notNull(entity, (String)"PersistentEntity must not be null");
        Assert.notNull((Object)value, (String)"Entity value must not be null");
        Assert.isInstanceOf((Class)entity.getType(), (Object)value, () -> String.format("Target bean of type %s is not of type of the persistent entity (%s)", value.getClass().getName(), entity.getType().getName()));
        HttpHeaders headers = ETag.from(entity, value).addTo(new HttpHeaders());
        this.getLastModifiedInMilliseconds(value).ifPresent(it -> headers.setLastModified(it.longValue()));
        return headers;
    }

    public boolean isObjectStillValid(Object source, HttpHeaders headers) {
        Assert.notNull((Object)source, (String)"Source object must not be null");
        Assert.notNull((Object)headers, (String)"HttpHeaders must not be null");
        if (headers.getIfModifiedSince() == -1L) {
            return false;
        }
        return this.getLastModifiedInMilliseconds(source).map(it -> it / 1000L * 1000L <= headers.getIfModifiedSince()).orElse(true);
    }

    private Optional<AuditableBeanWrapper<Object>> getAuditableBeanWrapper(Object source) {
        return this.auditableBeanWrapperFactory.getBeanWrapperFor(source);
    }

    private Optional<Long> getLastModifiedInMilliseconds(Object object) {
        return this.getAuditableBeanWrapper(object).flatMap(it -> it.getLastModifiedDate()).map(it -> (Date)this.conversionService.convert(it, Date.class)).map(it -> (Instant)this.conversionService.convert(it, Instant.class)).map(it -> it.toEpochMilli());
    }
}

