/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json.patch;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.jspecify.annotations.Nullable;
import org.springframework.data.rest.webmvc.json.patch.BindContext;
import org.springframework.data.rest.webmvc.json.patch.PatchException;
import org.springframework.data.rest.webmvc.json.patch.PatchOperation;
import org.springframework.data.rest.webmvc.json.patch.SpelPath;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class TestOperation
extends PatchOperation {
    private TestOperation(SpelPath.UntypedSpelPath path, @Nullable Object value) {
        super("test", path, value);
    }

    public static TestOperationBuilder whetherValueAt(String path) {
        return new TestOperationBuilder(path);
    }

    @Override
    void perform(Object target, Class<?> type, BindContext context) {
        Object actual;
        Object expected = TestOperation.normalizeIfNumber(this.evaluateValueFromTarget(target, type, context));
        if (!ObjectUtils.nullSafeEquals((Object)expected, (Object)(actual = TestOperation.normalizeIfNumber(this.path.bindForRead(type, context).getValue(target))))) {
            throw new PatchException("Test against path '" + String.valueOf(this.path) + "' failed");
        }
    }

    private static @Nullable Object normalizeIfNumber(@Nullable Object expected) {
        if (expected instanceof Double || expected instanceof Float) {
            expected = BigDecimal.valueOf(((Number)expected).doubleValue());
        } else if (expected instanceof Number) {
            expected = BigInteger.valueOf(((Number)expected).longValue());
        }
        return expected;
    }

    static class TestOperationBuilder {
        private final String path;

        private TestOperationBuilder(String path) {
            Assert.hasText((String)path, (String)"Path must not be null or empty");
            this.path = path;
        }

        public TestOperation hasValue(@Nullable Object value) {
            return new TestOperation(SpelPath.untyped(this.path), value);
        }
    }
}

