/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.projection.ProjectionDefinitions;
import org.springframework.data.rest.webmvc.support.DefaultExcerptProjector;
import org.springframework.data.rest.webmvc.support.Projector;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PersistentEntityProjector
extends DefaultExcerptProjector
implements Projector {
    private final ProjectionDefinitions definitions;
    private final ProjectionFactory factory;
    private final @Nullable String projection;

    public PersistentEntityProjector(ProjectionDefinitions projectionDefinitions, ProjectionFactory factory, @Nullable String projection, ResourceMappings mappings) {
        super(factory, mappings);
        Assert.notNull((Object)projectionDefinitions, (String)"ProjectionDefinitions must not be null");
        Assert.notNull((Object)factory, (String)"ProjectionFactory must not be null");
        this.factory = factory;
        this.definitions = projectionDefinitions;
        this.projection = projection;
    }

    @Override
    public Object project(Object source) {
        return this.projectWithDefault(source, Function.identity());
    }

    @Override
    public Object projectExcerpt(Object source) {
        return this.projectWithDefault(source, x$0 -> PersistentEntityProjector.super.projectExcerpt(x$0));
    }

    private Object projectWithDefault(Object source, Function<Object, Object> converter) {
        Assert.notNull((Object)source, (String)"Projection source must not be null");
        Assert.notNull(converter, (String)"Converter must not be null");
        if (!StringUtils.hasText((String)this.projection)) {
            return converter.apply(source);
        }
        Class projectionType = this.definitions.getProjectionType(source.getClass(), this.projection);
        return projectionType == null ? converter.apply(source) : this.factory.createProjection(projectionType, source);
    }
}

