/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.TermsResponse;
import org.apache.solr.common.util.NamedList;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.domain.Page;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.repository.util.ClassUtils;
import org.springframework.data.solr.VersionUtil;
import org.springframework.data.solr.core.query.FacetQuery;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.PivotField;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.data.solr.core.query.SimplePivotField;
import org.springframework.data.solr.core.query.result.FacetFieldEntry;
import org.springframework.data.solr.core.query.result.FacetPivotFieldEntry;
import org.springframework.data.solr.core.query.result.FacetQueryEntry;
import org.springframework.data.solr.core.query.result.HighlightEntry;
import org.springframework.data.solr.core.query.result.SimpleFacetFieldEntry;
import org.springframework.data.solr.core.query.result.SimpleFacetPivotEntry;
import org.springframework.data.solr.core.query.result.SimpleFacetQueryEntry;
import org.springframework.data.solr.core.query.result.SimpleTermsFieldEntry;
import org.springframework.data.solr.core.query.result.SolrResultPage;
import org.springframework.data.solr.core.query.result.TermsFieldEntry;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class ResultHelper {
    private ResultHelper() {
    }

    static Map<String, List<TermsFieldEntry>> convertTermsQueryResponseToTermsMap(QueryResponse response) {
        if (response == null || response.getTermsResponse() == null || response.getTermsResponse().getTermMap() == null) {
            return Collections.emptyMap();
        }
        TermsResponse termsResponse = response.getTermsResponse();
        LinkedHashMap<String, List<TermsFieldEntry>> result = new LinkedHashMap<String, List<TermsFieldEntry>>(termsResponse.getTermMap().size());
        for (Map.Entry entry : termsResponse.getTermMap().entrySet()) {
            ArrayList<SimpleTermsFieldEntry> terms = new ArrayList<SimpleTermsFieldEntry>(((List)entry.getValue()).size());
            for (TermsResponse.Term term : (List)entry.getValue()) {
                SimpleTermsFieldEntry termsEntry = new SimpleTermsFieldEntry(term.getTerm(), term.getFrequency());
                termsEntry.setField((String)entry.getKey());
                terms.add(termsEntry);
            }
            result.put((String)entry.getKey(), (List<TermsFieldEntry>)terms);
        }
        return result;
    }

    static Map<Field, Page<FacetFieldEntry>> convertFacetQueryResponseToFacetPageMap(FacetQuery query, QueryResponse response) {
        Assert.notNull((Object)query, (String)"Cannot convert response for 'null', query");
        if (!ResultHelper.hasFacets(query, response)) {
            return Collections.emptyMap();
        }
        HashMap<Field, Page<FacetFieldEntry>> facetResult = new HashMap<Field, Page<FacetFieldEntry>>();
        if (CollectionUtils.isNotEmpty((Collection)response.getFacetFields())) {
            int initalPageSize = query.getFacetOptions().getPageable().getPageSize();
            for (FacetField facetField : response.getFacetFields()) {
                if (facetField == null || !StringUtils.hasText((String)facetField.getName())) continue;
                SimpleField field = new SimpleField(facetField.getName());
                if (CollectionUtils.isNotEmpty((Collection)facetField.getValues())) {
                    ArrayList<SimpleFacetFieldEntry> pageEntries = new ArrayList<SimpleFacetFieldEntry>(initalPageSize);
                    for (FacetField.Count count : facetField.getValues()) {
                        if (count == null) continue;
                        pageEntries.add(new SimpleFacetFieldEntry(field, count.getName(), count.getCount()));
                    }
                    facetResult.put(field, new SolrResultPage(pageEntries, query.getFacetOptions().getPageable(), facetField.getValueCount(), null));
                    continue;
                }
                facetResult.put(field, new SolrResultPage(Collections.emptyList(), query.getFacetOptions().getPageable(), 0L, null));
            }
        }
        return facetResult;
    }

    static Map<PivotField, List<FacetPivotFieldEntry>> convertFacetQueryResponseToFacetPivotMap(FacetQuery query, QueryResponse response) {
        if (VersionUtil.isSolr3XAvailable()) {
            return Collections.emptyMap();
        }
        HashMap<PivotField, List<FacetPivotFieldEntry>> facetResult = new HashMap<PivotField, List<FacetPivotFieldEntry>>();
        NamedList facetPivot = response.getFacetPivot();
        if (facetPivot != null && facetPivot.size() > 0) {
            for (int i = 0; i < facetPivot.size(); ++i) {
                String name = facetPivot.getName(i);
                List pivotResult = (List)facetPivot.get(name);
                facetResult.put(new SimplePivotField(name), ResultHelper.convertPivotResult(pivotResult));
            }
        }
        return facetResult;
    }

    private static List<FacetPivotFieldEntry> convertPivotResult(List<org.apache.solr.client.solrj.response.PivotField> pivotResult) {
        if (CollectionUtils.isEmpty(pivotResult)) {
            return Collections.emptyList();
        }
        ArrayList<FacetPivotFieldEntry> pivotFieldEntries = new ArrayList<FacetPivotFieldEntry>();
        for (org.apache.solr.client.solrj.response.PivotField pivotField : pivotResult) {
            SimpleFacetPivotEntry pivotFieldEntry = new SimpleFacetPivotEntry(new SimpleField(pivotField.getField()), String.valueOf(pivotField.getValue()), pivotField.getCount());
            List pivot = pivotField.getPivot();
            if (pivot != null) {
                pivotFieldEntry.setPivot(ResultHelper.convertPivotResult(pivot));
            }
            pivotFieldEntries.add(pivotFieldEntry);
        }
        return pivotFieldEntries;
    }

    static List<FacetQueryEntry> convertFacetQueryResponseToFacetQueryResult(FacetQuery query, QueryResponse response) {
        Assert.notNull((Object)query, (String)"Cannot convert response for 'null', query");
        if (!ResultHelper.hasFacets(query, response)) {
            return Collections.emptyList();
        }
        ArrayList<FacetQueryEntry> facetResult = new ArrayList<FacetQueryEntry>();
        if (MapUtils.isNotEmpty((Map)response.getFacetQuery())) {
            for (Map.Entry entry : response.getFacetQuery().entrySet()) {
                facetResult.add(new SimpleFacetQueryEntry((String)entry.getKey(), ((Integer)entry.getValue()).intValue()));
            }
        }
        return facetResult;
    }

    static <T> List<HighlightEntry<T>> convertAndAddHighlightQueryResponseToResultPage(QueryResponse response, SolrResultPage<T> page) {
        if (response == null || MapUtils.isEmpty((Map)response.getHighlighting()) || page == null) {
            return Collections.emptyList();
        }
        ArrayList mappedHighlights = new ArrayList(page.getSize());
        Map highlighting = response.getHighlighting();
        Iterator iterator = page.iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            HighlightEntry highlightEntry = ResultHelper.processHighlightingForPageEntry(highlighting, item);
            mappedHighlights.add(highlightEntry);
        }
        page.setHighlighted(mappedHighlights);
        return mappedHighlights;
    }

    private static <T> HighlightEntry<T> processHighlightingForPageEntry(Map<String, Map<String, List<String>>> highlighting, T pageEntry) {
        HighlightEntry<T> highlightEntry = new HighlightEntry<T>(pageEntry);
        Object itemId = ResultHelper.getMappedId(pageEntry);
        Map<String, List<String>> highlights = highlighting.get(itemId.toString());
        if (MapUtils.isNotEmpty(highlights)) {
            for (Map.Entry<String, List<String>> entry : highlights.entrySet()) {
                highlightEntry.addSnipplets(entry.getKey(), entry.getValue());
            }
        }
        return highlightEntry;
    }

    private static Object getMappedId(Object o) {
        if (ClassUtils.hasProperty(o.getClass(), (String)"id")) {
            try {
                return FieldUtils.readDeclaredField((Object)o, (String)"id", (boolean)true);
            }
            catch (IllegalAccessException e) {
                throw new MappingException("Id property could not be accessed!", (Throwable)e);
            }
        }
        for (java.lang.reflect.Field field : o.getClass().getDeclaredFields()) {
            Annotation annotation = AnnotationUtils.getAnnotation((AnnotatedElement)field, Id.class);
            if (annotation == null) continue;
            try {
                return FieldUtils.readField((java.lang.reflect.Field)field, (Object)o, (boolean)true);
            }
            catch (IllegalArgumentException e) {
                throw new MappingException("Id property could not be accessed!", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new MappingException("Id property could not be accessed!", (Throwable)e);
            }
        }
        throw new MappingException("Id property could not be found!");
    }

    private static boolean hasFacets(FacetQuery query, QueryResponse response) {
        return query.hasFacetOptions() && response != null;
    }
}

