/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.solr.core.query.Crotch;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.Function;
import org.springframework.data.solr.core.query.Node;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.util.Assert;

public class Criteria
extends Node {
    public static final String WILDCARD = "*";
    public static final String CRITERIA_VALUE_SEPERATOR = " ";
    private Field field;
    private float boost = Float.NaN;
    private boolean negating = false;
    private Set<Predicate> predicates = new LinkedHashSet<Predicate>();

    public Criteria() {
    }

    public Criteria(Function function) {
        Assert.notNull((Object)function, (String)"Cannot create Critiera for 'null' function.");
        this.function(function);
    }

    public Criteria(String fieldname) {
        this(new SimpleField(fieldname));
    }

    public Criteria(Field field) {
        Assert.notNull((Object)field, (String)"Field for criteria must not be null");
        Assert.hasText((String)field.getName(), (String)"Field.name for criteria must not be null/empty");
        this.field = field;
    }

    public static Criteria where(String fieldname) {
        return Criteria.where(new SimpleField(fieldname));
    }

    public static Criteria where(Function function) {
        return new Criteria(function);
    }

    public static Criteria where(Field field) {
        return new Criteria(field);
    }

    @Override
    public Criteria is(Object o) {
        if (o == null) {
            return this.isNull();
        }
        this.predicates.add(new Predicate(OperationKey.EQUALS, o));
        return this;
    }

    @Override
    public Criteria is(Object ... values) {
        return this.in(values);
    }

    @Override
    public Criteria is(Iterable<?> values) {
        return this.in((Iterable)values);
    }

    @Override
    public Criteria isNull() {
        return this.between(null, null).not();
    }

    @Override
    public Criteria isNotNull() {
        return this.between(null, null);
    }

    @Override
    public Criteria contains(String s) {
        this.assertNoBlankInWildcardedQuery(s, true, true);
        this.predicates.add(new Predicate(OperationKey.CONTAINS, (Object)s));
        return this;
    }

    @Override
    public Criteria contains(String ... values) {
        this.assertValuesPresent(values);
        return this.contains(Arrays.asList(values));
    }

    @Override
    public Criteria contains(Iterable<String> values) {
        Assert.notNull(values, (String)"Collection must not be null");
        for (String value : values) {
            this.contains(value);
        }
        return this;
    }

    @Override
    public Criteria startsWith(String s) {
        this.assertNoBlankInWildcardedQuery(s, false, true);
        this.predicates.add(new Predicate(OperationKey.STARTS_WITH, (Object)s));
        return this;
    }

    @Override
    public Criteria startsWith(String ... values) {
        this.assertValuesPresent(values);
        return this.startsWith(Arrays.asList(values));
    }

    @Override
    public Criteria startsWith(Iterable<String> values) {
        Assert.notNull(values, (String)"Collection must not be null");
        for (String value : values) {
            this.startsWith(value);
        }
        return this;
    }

    @Override
    public Criteria endsWith(String s) {
        this.assertNoBlankInWildcardedQuery(s, true, false);
        this.predicates.add(new Predicate(OperationKey.ENDS_WITH, (Object)s));
        return this;
    }

    @Override
    public Criteria endsWith(String ... values) {
        this.assertValuesPresent(values);
        return this.endsWith(Arrays.asList(values));
    }

    @Override
    public Criteria endsWith(Iterable<String> values) {
        Assert.notNull(values, (String)"Collection must not be null");
        for (String value : values) {
            this.endsWith(value);
        }
        return this;
    }

    @Override
    public Criteria not() {
        this.negating = true;
        return this;
    }

    @Override
    public Criteria fuzzy(String s) {
        return this.fuzzy(s, Float.NaN);
    }

    @Override
    public Criteria fuzzy(String s, float levenshteinDistance) {
        if (!Float.isNaN(levenshteinDistance) && (levenshteinDistance < 0.0f || levenshteinDistance > 1.0f)) {
            throw new InvalidDataAccessApiUsageException("Levenshtein Distance has to be within its bounds (0.0 - 1.0).");
        }
        this.predicates.add(new Predicate(OperationKey.FUZZY, (Object)new Object[]{s, Float.valueOf(levenshteinDistance)}));
        return this;
    }

    @Override
    public Criteria sloppy(String phrase, int distance) {
        if (distance <= 0) {
            throw new InvalidDataAccessApiUsageException("Slop distance has to be greater than 0.");
        }
        if (!StringUtils.contains((CharSequence)phrase, (CharSequence)CRITERIA_VALUE_SEPERATOR)) {
            throw new InvalidDataAccessApiUsageException("Phrase must consist of multiple terms, separated with spaces.");
        }
        this.predicates.add(new Predicate(OperationKey.SLOPPY, (Object)new Object[]{phrase, distance}));
        return this;
    }

    @Override
    public Criteria expression(String s) {
        this.predicates.add(new Predicate(OperationKey.EXPRESSION, (Object)s));
        return this;
    }

    @Override
    public Criteria boost(float boost) {
        if (boost < 0.0f) {
            throw new InvalidDataAccessApiUsageException("Boost must not be negative.");
        }
        this.boost = boost;
        return this;
    }

    @Override
    public Criteria between(Object lowerBound, Object upperBound) {
        return this.between(lowerBound, upperBound, true, true);
    }

    @Override
    public Criteria between(Object lowerBound, Object upperBound, boolean includeLowerBound, boolean includeUppderBound) {
        this.predicates.add(new Predicate(OperationKey.BETWEEN, (Object)new Object[]{lowerBound, upperBound, includeLowerBound, includeUppderBound}));
        return this;
    }

    @Override
    public Criteria lessThan(Object upperBound) {
        this.between(null, upperBound, true, false);
        return this;
    }

    @Override
    public Criteria lessThanEqual(Object upperBound) {
        this.between(null, upperBound);
        return this;
    }

    @Override
    public Criteria greaterThan(Object lowerBound) {
        this.between(lowerBound, null, false, true);
        return this;
    }

    @Override
    public Criteria greaterThanEqual(Object lowerBound) {
        this.between(lowerBound, null);
        return this;
    }

    @Override
    public Criteria in(Object ... values) {
        this.assertValuesPresent(values);
        return this.in(Arrays.asList(values));
    }

    @Override
    public Criteria in(Iterable<?> values) {
        Assert.notNull(values, (String)"Collection of 'in' values must not be null");
        for (Object value : values) {
            if (value instanceof Collection) {
                this.in((Iterable)((Collection)value));
                continue;
            }
            this.is(value);
        }
        return this;
    }

    @Override
    public Criteria within(Point location, Distance distance) {
        Assert.notNull((Object)location);
        this.assertPositiveDistanceValue(distance);
        this.predicates.add(new Predicate(OperationKey.WITHIN, (Object)new Object[]{location, distance != null ? distance : new Distance(0.0)}));
        return this;
    }

    public Criteria within(Circle circle) {
        Assert.notNull((Object)circle, (String)"Circle for 'within' must not be 'null'.");
        return this.within(circle.getCenter(), circle.getRadius());
    }

    @Override
    public Criteria near(Box box) {
        this.predicates.add(new Predicate(OperationKey.NEAR, (Object)new Object[]{box}));
        return this;
    }

    @Override
    public Criteria near(Point location, Distance distance) {
        Assert.notNull((Object)location, (String)"Location must not be 'null' for near criteria.");
        this.assertPositiveDistanceValue(distance);
        this.predicates.add(new Predicate(OperationKey.NEAR, (Object)new Object[]{location, distance != null ? distance : new Distance(0.0)}));
        return this;
    }

    public Criteria near(Circle circle) {
        Assert.notNull((Object)circle, (String)"Circle for 'near' must not be 'null'.");
        return this.near(circle.getCenter(), circle.getRadius());
    }

    @Override
    public Criteria function(Function function) {
        Assert.notNull((Object)function, (String)"Cannot add 'null' function to criteria.");
        this.predicates.add(new Predicate(OperationKey.FUNCTION, (Object)function));
        return this;
    }

    public Field getField() {
        return this.field;
    }

    public boolean isNegating() {
        return this.negating;
    }

    public float getBoost() {
        return this.boost;
    }

    public Set<Predicate> getPredicates() {
        return Collections.unmodifiableSet(this.predicates);
    }

    private void assertPositiveDistanceValue(Distance distance) {
        if (distance != null && distance.getValue() < 0.0) {
            throw new InvalidDataAccessApiUsageException("distance must not be negative.");
        }
    }

    private void assertNoBlankInWildcardedQuery(String searchString, boolean leadingWildcard, boolean trailingWildcard) {
        if (StringUtils.contains((CharSequence)searchString, (CharSequence)CRITERIA_VALUE_SEPERATOR)) {
            throw new InvalidDataAccessApiUsageException("Cannot constructQuery '" + (leadingWildcard ? WILDCARD : "") + "\"" + searchString + "\"" + (trailingWildcard ? WILDCARD : "") + "'. Use epxression or mulitple clauses instead.");
        }
    }

    private void assertValuesPresent(Object ... values) {
        if (values.length == 0 || values.length > 1 && values[1] instanceof Collection) {
            throw new InvalidDataAccessApiUsageException("At least one element " + (values.length > 0 ? "of argument of type " + values[1].getClass().getName() : "") + " has to be present.");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.isOr() ? "OR " : "AND ");
        sb.append(this.isNegating() ? "!" : "");
        sb.append(this.field != null ? this.field.getName() : "");
        if (this.predicates.size() > 1) {
            sb.append('(');
        }
        for (Predicate ce : this.predicates) {
            sb.append(ce.toString());
        }
        if (this.predicates.size() > 1) {
            sb.append(')');
        }
        sb.append(' ');
        return sb.toString();
    }

    public Crotch and(Node node) {
        if (!(node instanceof Criteria)) {
            throw new IllegalArgumentException("Can only add instances of Criteria");
        }
        Crotch crotch = new Crotch();
        crotch.setParent(this.getParent());
        crotch.add(this);
        crotch.add((Criteria)node);
        return crotch;
    }

    public Crotch and(String fieldname) {
        Criteria node = new Criteria(fieldname);
        return this.and(node);
    }

    public Crotch or(Node node) {
        if (!(node instanceof Criteria)) {
            throw new IllegalArgumentException("Can only add instances of Criteria");
        }
        node.setPartIsOr(true);
        Crotch crotch = new Crotch();
        crotch.setParent(this.getParent());
        crotch.add(this);
        crotch.add((Criteria)node);
        return crotch;
    }

    public Crotch or(String fieldname) {
        Criteria node = new Criteria(fieldname);
        node.setPartIsOr(true);
        return this.or(node);
    }

    public static class Predicate {
        private String key;
        private Object value;

        public Predicate(OperationKey key, Object value) {
            this(key.getKey(), value);
        }

        public Predicate(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String toString() {
            return this.key + ":" + this.value;
        }
    }

    public static enum OperationKey {
        EQUALS("$equals"),
        CONTAINS("$contains"),
        STARTS_WITH("$startsWith"),
        ENDS_WITH("$endsWith"),
        EXPRESSION("$expression"),
        BETWEEN("$between"),
        NEAR("$near"),
        WITHIN("$within"),
        FUZZY("$fuzzy"),
        SLOPPY("$sloppy"),
        FUNCTION("$function");

        private final String key;

        private OperationKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

