/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.schema;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.springframework.data.solr.core.schema.ContentParser;
import org.springframework.data.solr.core.schema.MappingJacksonRequestContentParser;
import org.springframework.data.solr.core.schema.MappingJacksonResponseParser;
import org.springframework.data.solr.core.schema.SolrJsonResponse;
import org.springframework.util.StopWatch;
import org.springframework.util.StreamUtils;

public class SolrJsonRequest
extends SolrRequest {
    private static final long serialVersionUID = 5786008418321490550L;
    private ModifiableSolrParams params = new ModifiableSolrParams();
    private List<ContentStream> contentStream = null;
    private ContentParser contentParser;

    public SolrJsonRequest(SolrRequest.METHOD method, String path) {
        super(method, path);
        this.setResponseParser(new MappingJacksonResponseParser());
        this.setContentParser(new MappingJacksonRequestContentParser());
    }

    private void setContentParser(ContentParser requestParser) {
        this.contentParser = requestParser != null ? requestParser : new MappingJacksonRequestContentParser();
    }

    public ContentParser getContentParser() {
        return this.contentParser;
    }

    public SolrParams getParams() {
        return this.params;
    }

    public Collection<ContentStream> getContentStreams() throws IOException {
        return this.contentStream != null ? Collections.unmodifiableCollection(this.contentStream) : null;
    }

    public SolrJsonResponse process(SolrServer server) throws SolrServerException, IOException {
        SolrJsonResponse response = new SolrJsonResponse();
        StopWatch sw = new StopWatch();
        sw.start();
        response.setResponse((NamedList<Object>)server.request((SolrRequest)this));
        sw.stop();
        response.setElapsedTime(sw.getTotalTimeMillis());
        return response;
    }

    public void addContentToStream(Object content) {
        if (this.contentStream == null) {
            this.contentStream = new ArrayList<ContentStream>();
        }
        this.contentStream.add(this.getContentParser().parse(content));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getMethod().toString());
        sb.append(" ");
        sb.append(this.getPath());
        sb.append("\r\n");
        sb.append(this.quietlyReadContentStreams());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String quietlyReadContentStreams() {
        StringBuilder sb = new StringBuilder();
        if (this.contentStream != null) {
            for (ContentStream stream : this.contentStream) {
                InputStream ioStream = null;
                try {
                    ioStream = stream.getStream();
                    sb.append(StreamUtils.copyToString((InputStream)ioStream, (Charset)Charset.forName("UTF-8")));
                }
                catch (IOException e) {}
                continue;
                finally {
                    if (ioStream == null) continue;
                    try {
                        ioStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return sb.toString();
    }
}

