/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.schema;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.solr.core.SolrExceptionTranslator;
import org.springframework.data.solr.core.schema.SchemaDefinition;
import org.springframework.data.solr.core.schema.SolrJsonResponse;
import org.springframework.data.solr.core.schema.SolrSchemaRequest;
import org.springframework.data.solr.server.SolrClientFactory;
import org.springframework.util.CollectionUtils;

public class SolrSchemaWriter {
    private static final PersistenceExceptionTranslator EXCEPTION_TRANSLATOR = new SolrExceptionTranslator();
    private SolrClientFactory factory;

    public SolrSchemaWriter(SolrClientFactory factory) {
        this.factory = factory;
    }

    public void writeSchema(SchemaDefinition schemaDefinition) {
        if (this.isSchemaPresent(schemaDefinition.getCollectionName())) {
            this.updateSchema(schemaDefinition);
            return;
        }
        this.createSchema(schemaDefinition);
    }

    protected void createSchema(SchemaDefinition schemaDefinition) {
        throw new UnsupportedOperationException("The solr rest API does not allow schema creation.");
    }

    protected void updateSchema(SchemaDefinition schemaDefinition) {
        SchemaDefinition existing = this.loadExistingSchema(schemaDefinition.getCollectionName());
        ArrayList<SchemaDefinition.FieldDefinition> fieldsToBeCreated = new ArrayList<SchemaDefinition.FieldDefinition>();
        for (SchemaDefinition.FieldDefinition fieldDefinition : schemaDefinition.getFields()) {
            if (existing.containsField(fieldDefinition.getName())) continue;
            fieldsToBeCreated.add(fieldDefinition);
        }
        this.writeFieldDefinitions(fieldsToBeCreated, schemaDefinition.getCollectionName());
    }

    private void writeFieldDefinitions(Collection<SchemaDefinition.FieldDefinition> definitions, String collectionName) {
        if (!CollectionUtils.isEmpty(definitions)) {
            try {
                SolrSchemaRequest.create().fields(definitions).build().process(this.factory.getSolrClient(collectionName));
            }
            catch (SolrServerException e) {
                throw EXCEPTION_TRANSLATOR.translateExceptionIfPossible(new RuntimeException(e));
            }
            catch (IOException e) {
                throw new InvalidDataAccessResourceUsageException("Failed to write schema field definitions.", (Throwable)e);
            }
        }
    }

    boolean isSchemaPresent(String collectionName) {
        return !this.retrieveSchemaVersion(collectionName).isNaN();
    }

    SchemaDefinition loadExistingSchema(String collectionName) {
        try {
            SolrJsonResponse response = (SolrJsonResponse)SolrSchemaRequest.schema().process(this.factory.getSolrClient(collectionName));
            if (response != null && response.getNode("schema") != null) {
                ObjectMapper mapper = new ObjectMapper();
                mapper.enable(new MapperFeature[]{MapperFeature.AUTO_DETECT_CREATORS});
                mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
                return (SchemaDefinition)mapper.readValue(response.getNode("schema").toString(), SchemaDefinition.class);
            }
            return null;
        }
        catch (SolrServerException e) {
            throw EXCEPTION_TRANSLATOR.translateExceptionIfPossible(new RuntimeException(e));
        }
        catch (IOException e) {
            throw new InvalidDataAccessResourceUsageException("Failed to load schema definition.", (Throwable)e);
        }
        catch (SolrException e) {
            throw EXCEPTION_TRANSLATOR.translateExceptionIfPossible(new RuntimeException(e));
        }
    }

    Double retrieveSchemaVersion(String collectionName) {
        try {
            SolrJsonResponse response = (SolrJsonResponse)SolrSchemaRequest.version().process(this.factory.getSolrClient(collectionName));
            JsonNode node = response.getNode("version");
            return node != null ? node.asDouble() : Double.NaN;
        }
        catch (SolrServerException e) {
            EXCEPTION_TRANSLATOR.translateExceptionIfPossible(new RuntimeException(e));
        }
        catch (IOException e) {
            EXCEPTION_TRANSLATOR.translateExceptionIfPossible(new RuntimeException(e));
        }
        catch (SolrException e) {
            EXCEPTION_TRANSLATOR.translateExceptionIfPossible(new RuntimeException(e));
        }
        return Double.NaN;
    }
}

