/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.server.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrClient;
import org.springframework.data.solr.server.support.SolrClientFactoryBase;
import org.springframework.data.solr.server.support.SolrClientUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class MulticoreSolrClientFactory
extends SolrClientFactoryBase {
    private boolean createMissingSolrClient = true;
    private Map<String, SolrClient> clientMap = new LinkedHashMap<String, SolrClient>();

    protected MulticoreSolrClientFactory() {
    }

    public MulticoreSolrClientFactory(SolrClient solrServer) {
        this(solrServer, Collections.emptyList());
    }

    public MulticoreSolrClientFactory(SolrClient solrServer, String ... cores) {
        this(solrServer, cores != null ? Arrays.asList(cores) : Collections.emptyList());
    }

    public MulticoreSolrClientFactory(SolrClient solrServer, List<String> cores) {
        super(solrServer);
        for (String core : cores) {
            this.addSolrClientForCore(this.createClientForCore(solrServer, core), core);
        }
    }

    @Override
    public SolrClient getSolrClient(String core) {
        if (!StringUtils.hasText((String)core)) {
            return this.getSolrClient();
        }
        if (this.createMissingSolrClient && !this.clientMap.containsKey(core)) {
            this.clientMap.put(core, this.createClientForCore(this.getSolrClient(), core));
        }
        return this.clientMap.get(core);
    }

    public void addSolrClientForCore(SolrClient solrClient, String core) {
        this.clientMap.put(core, solrClient);
    }

    public void removeSolrClient(String core) {
        if (this.clientMap.containsKey(core)) {
            this.destroy(this.clientMap.remove(core));
        }
    }

    public SolrClient getSolrClient(Class<?> clazz) {
        Assert.notNull(clazz);
        String coreName = SolrClientUtils.resolveSolrCoreName(clazz);
        return this.getSolrClient(StringUtils.hasText((String)coreName) ? coreName : MulticoreSolrClientFactory.getShortClassName(clazz));
    }

    protected static String getShortClassName(Class<?> clazz) {
        String shortName = ClassUtils.getShortName(clazz);
        int dotIndex = shortName.lastIndexOf(46);
        return dotIndex != -1 ? shortName.substring(dotIndex + 1) : shortName;
    }

    @Override
    public List<String> getCores() {
        return new ArrayList<String>(this.clientMap.keySet());
    }

    @Override
    public void destroy() {
        super.destroy();
        for (SolrClient server : this.clientMap.values()) {
            this.destroy(server);
        }
    }

    protected SolrClient createClientForCore(SolrClient reference, String core) {
        if (StringUtils.hasText((String)core)) {
            return SolrClientUtils.clone(reference, core);
        }
        return reference;
    }

    public boolean isCreateMissingSolrClient() {
        return this.createMissingSolrClient;
    }

    public void setCreateMissingSolrClient(boolean createMissingSolrClient) {
        this.createMissingSolrClient = createMissingSolrClient;
    }
}

