/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query.result;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.Function;
import org.springframework.data.solr.core.query.PivotField;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.data.solr.core.query.SimplePivotField;
import org.springframework.data.solr.core.query.result.FacetAndHighlightPage;
import org.springframework.data.solr.core.query.result.FacetEntry;
import org.springframework.data.solr.core.query.result.FacetFieldEntry;
import org.springframework.data.solr.core.query.result.FacetPage;
import org.springframework.data.solr.core.query.result.FacetPivotFieldEntry;
import org.springframework.data.solr.core.query.result.FacetQueryEntry;
import org.springframework.data.solr.core.query.result.FieldStatsResult;
import org.springframework.data.solr.core.query.result.GroupPage;
import org.springframework.data.solr.core.query.result.GroupResult;
import org.springframework.data.solr.core.query.result.HighlightEntry;
import org.springframework.data.solr.core.query.result.HighlightPage;
import org.springframework.data.solr.core.query.result.PageKey;
import org.springframework.data.solr.core.query.result.ScoredPage;
import org.springframework.data.solr.core.query.result.SpellcheckQueryResult;
import org.springframework.data.solr.core.query.result.SpellcheckedPage;
import org.springframework.data.solr.core.query.result.StatsPage;
import org.springframework.data.solr.core.query.result.StringPageKey;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class SolrResultPage<T>
extends PageImpl<T>
implements FacetPage<T>,
HighlightPage<T>,
FacetAndHighlightPage<T>,
ScoredPage<T>,
GroupPage<T>,
StatsPage<T>,
SpellcheckedPage<T> {
    private static final long serialVersionUID = -4199560685036530258L;
    private Map<PageKey, Page<FacetFieldEntry>> facetResultPages = new LinkedHashMap<PageKey, Page<FacetFieldEntry>>(1);
    private Map<PageKey, List<FacetPivotFieldEntry>> facetPivotResultPages = new LinkedHashMap<PageKey, List<FacetPivotFieldEntry>>();
    private Map<PageKey, Page<FacetFieldEntry>> facetRangeResultPages = new LinkedHashMap<PageKey, Page<FacetFieldEntry>>(1);
    private Page<FacetQueryEntry> facetQueryResult;
    private List<HighlightEntry<T>> highlighted;
    private Float maxScore;
    private Map<Object, GroupResult<T>> groupResults = Collections.emptyMap();
    private Map<String, FieldStatsResult> fieldStatsResults;
    private Map<String, List<SpellcheckQueryResult.Alternative>> suggestions = new LinkedHashMap<String, List<SpellcheckQueryResult.Alternative>>();

    public SolrResultPage(List<T> content) {
        super(content);
    }

    public SolrResultPage(List<T> content, Pageable pageable, long total, Float maxScore) {
        super(content, pageable, total);
        this.maxScore = maxScore;
    }

    private Page<FacetFieldEntry> getResultPage(String fieldname, Map<PageKey, Page<FacetFieldEntry>> resultPages) {
        PageImpl page = resultPages.get(new StringPageKey(fieldname));
        return page != null ? page : new PageImpl(Collections.emptyList());
    }

    @Override
    public final Page<FacetFieldEntry> getFacetResultPage(String fieldname) {
        return this.getResultPage(fieldname, this.facetResultPages);
    }

    @Override
    public final Page<FacetFieldEntry> getRangeFacetResultPage(String fieldname) {
        return this.getResultPage(fieldname, this.facetRangeResultPages);
    }

    @Override
    public final Page<FacetFieldEntry> getFacetResultPage(Field field) {
        return this.getFacetResultPage(field.getName());
    }

    @Override
    public final Page<FacetFieldEntry> getRangeFacetResultPage(Field field) {
        return this.getRangeFacetResultPage(field.getName());
    }

    @Override
    public List<FacetPivotFieldEntry> getPivot(String fieldName) {
        return this.facetPivotResultPages.get(new StringPageKey(fieldName));
    }

    @Override
    public List<FacetPivotFieldEntry> getPivot(PivotField field) {
        return this.facetPivotResultPages.get(new StringPageKey(field.getName()));
    }

    public final void addFacetResultPage(Page<FacetFieldEntry> page, Field field) {
        this.facetResultPages.put(new StringPageKey(field.getName()), page);
    }

    public final void addRangeFacetResultPage(Page<FacetFieldEntry> page, Field field) {
        this.facetRangeResultPages.put(new StringPageKey(field.getName()), page);
    }

    public final void addFacetPivotResultPage(List<FacetPivotFieldEntry> result, PivotField field) {
        this.facetPivotResultPages.put(new StringPageKey(field.getName()), result);
    }

    public void addAllFacetFieldResultPages(Map<Field, Page<FacetFieldEntry>> pageMap) {
        for (Map.Entry<Field, Page<FacetFieldEntry>> entry : pageMap.entrySet()) {
            this.addFacetResultPage(entry.getValue(), entry.getKey());
        }
    }

    public void addAllRangeFacetFieldResultPages(Map<Field, Page<FacetFieldEntry>> pageMap) {
        for (Map.Entry<Field, Page<FacetFieldEntry>> entry : pageMap.entrySet()) {
            this.addRangeFacetResultPage(entry.getValue(), entry.getKey());
        }
    }

    public void addAllFacetPivotFieldResult(Map<PivotField, List<FacetPivotFieldEntry>> resultMap) {
        for (Map.Entry<PivotField, List<FacetPivotFieldEntry>> entry : resultMap.entrySet()) {
            this.addFacetPivotResultPage(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public Collection<Page<FacetFieldEntry>> getFacetResultPages() {
        return Collections.unmodifiableCollection(this.facetResultPages.values());
    }

    public final void setFacetQueryResultPage(List<FacetQueryEntry> facetQueryResult) {
        this.facetQueryResult = new PageImpl(facetQueryResult);
    }

    @Override
    public Page<FacetQueryEntry> getFacetQueryResult() {
        return this.facetQueryResult != null ? this.facetQueryResult : new PageImpl(Collections.emptyList());
    }

    @Override
    public Collection<Field> getFacetFields() {
        if (this.facetResultPages.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Field> fields = new ArrayList<Field>(this.facetResultPages.size());
        for (PageKey pageKey : this.facetResultPages.keySet()) {
            fields.add(new SimpleField(pageKey.getKey().toString()));
        }
        return fields;
    }

    @Override
    public Collection<PivotField> getFacetPivotFields() {
        if (this.facetPivotResultPages.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PivotField> fields = new ArrayList<PivotField>(this.facetPivotResultPages.size());
        for (PageKey pageKey : this.facetPivotResultPages.keySet()) {
            fields.add(new SimplePivotField(pageKey.getKey().toString()));
        }
        return fields;
    }

    @Override
    public Collection<Page<? extends FacetEntry>> getAllFacets() {
        ArrayList<Page<? extends FacetEntry>> entries = new ArrayList<Page<? extends FacetEntry>>(this.facetResultPages.size() + 1);
        entries.addAll(this.facetResultPages.values());
        entries.add(this.facetQueryResult);
        return entries;
    }

    @Override
    public List<HighlightEntry<T>> getHighlighted() {
        return this.highlighted != null ? this.highlighted : Collections.emptyList();
    }

    public void setHighlighted(List<HighlightEntry<T>> highlighted) {
        this.highlighted = highlighted;
    }

    @Override
    public List<HighlightEntry.Highlight> getHighlights(T entity) {
        if (entity != null && this.highlighted != null) {
            for (HighlightEntry<T> highlightEntry : this.highlighted) {
                if (highlightEntry == null || !ObjectUtils.nullSafeEquals(highlightEntry.getEntity(), entity)) continue;
                return highlightEntry.getHighlights();
            }
        }
        return Collections.emptyList();
    }

    public void setGroupResults(Map<Object, GroupResult<T>> groupResults) {
        this.groupResults = groupResults;
    }

    @Override
    public Float getMaxScore() {
        return this.maxScore;
    }

    @Override
    public GroupResult<T> getGroupResult(Field field) {
        Assert.notNull((Object)field, (String)"group result field must not be null");
        return this.groupResults.get(field.getName());
    }

    @Override
    public GroupResult<T> getGroupResult(Function function) {
        Assert.notNull((Object)function, (String)"group result function must not be null");
        return this.groupResults.get(function);
    }

    @Override
    public GroupResult<T> getGroupResult(Query query) {
        Assert.notNull((Object)query, (String)"group result query must not be null");
        return this.groupResults.get(query);
    }

    @Override
    public GroupResult<T> getGroupResult(String name) {
        Assert.notNull((Object)name, (String)"group result name must not be null");
        return this.groupResults.get(name);
    }

    public void setFieldStatsResults(Map<String, FieldStatsResult> fieldStatsResults) {
        this.fieldStatsResults = fieldStatsResults;
    }

    @Override
    public FieldStatsResult getFieldStatsResult(Field field) {
        return this.getFieldStatsResult(field.getName());
    }

    @Override
    public FieldStatsResult getFieldStatsResult(String fieldName) {
        return this.fieldStatsResults.get(fieldName);
    }

    @Override
    public Map<String, FieldStatsResult> getFieldStatsResults() {
        return this.fieldStatsResults;
    }

    @Override
    public Collection<String> getSuggestions(String term) {
        ArrayList<String> suggestions = new ArrayList<String>();
        for (SpellcheckQueryResult.Alternative alternative : this.getAlternatives(term)) {
            suggestions.add(alternative.getSuggestion());
        }
        return suggestions;
    }

    @Override
    public Collection<String> getSuggestions() {
        ArrayList<String> suggestions = new ArrayList<String>();
        for (SpellcheckQueryResult.Alternative alternative : this.getAlternatives()) {
            suggestions.add(alternative.getSuggestion());
        }
        return suggestions;
    }

    @Override
    public void addSuggestions(String term, List<SpellcheckQueryResult.Alternative> suggestions) {
        this.suggestions.put(term, suggestions);
    }

    @Override
    public Collection<SpellcheckQueryResult.Alternative> getAlternatives() {
        ArrayList<SpellcheckQueryResult.Alternative> allSuggestions = new ArrayList<SpellcheckQueryResult.Alternative>();
        for (List<SpellcheckQueryResult.Alternative> suggestions : this.suggestions.values()) {
            allSuggestions.addAll(suggestions);
        }
        return allSuggestions;
    }

    @Override
    public Collection<SpellcheckQueryResult.Alternative> getAlternatives(String term) {
        return this.suggestions.containsKey(term) ? Collections.unmodifiableList(this.suggestions.get(term)) : Collections.emptyList();
    }
}

