/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.schema;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.schema.SchemaRequest;
import org.apache.solr.client.solrj.response.schema.SchemaRepresentation;
import org.apache.solr.client.solrj.response.schema.SchemaResponse;
import org.springframework.data.solr.core.CollectionCallback;
import org.springframework.data.solr.core.SolrTemplate;
import org.springframework.data.solr.core.schema.SchemaDefinition;
import org.springframework.data.solr.core.schema.SchemaModificationException;
import org.springframework.data.solr.core.schema.SchemaOperations;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class DefaultSchemaOperations
implements SchemaOperations {
    private final SolrTemplate template;
    private final String collection;

    public DefaultSchemaOperations(String collection, SolrTemplate template) {
        Assert.hasText((String)collection, (String)"Collection must not be null or empty!");
        Assert.notNull((Object)template, (String)"Template must not be null.");
        this.template = template;
        this.collection = collection;
    }

    @Override
    public String getSchemaName() {
        return this.template.execute(this.collection, new CollectionCallback<String>(){

            @Override
            public String doInSolr(SolrClient solrClient, String collection) throws SolrServerException, IOException {
                return ((SchemaResponse.SchemaNameResponse)new SchemaRequest.SchemaName().process(solrClient, collection)).getSchemaName();
            }
        });
    }

    @Override
    public Double getSchemaVersion() {
        return this.template.execute(this.collection, new CollectionCallback<Double>(){

            @Override
            public Double doInSolr(SolrClient solrClient, String collection) throws SolrServerException, IOException {
                return new Double(((SchemaResponse.SchemaVersionResponse)new SchemaRequest.SchemaVersion().process(solrClient, collection)).getSchemaVersion());
            }
        });
    }

    @Override
    public SchemaDefinition readSchema() {
        SchemaRepresentation representation = this.template.execute(this.collection, new CollectionCallback<SchemaRepresentation>(){

            @Override
            public SchemaRepresentation doInSolr(SolrClient solrClient, String collection) throws SolrServerException, IOException {
                return ((SchemaResponse)new SchemaRequest().process(solrClient, collection)).getSchemaRepresentation();
            }
        });
        SchemaDefinition sd = new SchemaDefinition(this.collection);
        for (Map fieldValueMap : representation.getFields()) {
            sd.addFieldDefinition(SchemaDefinition.FieldDefinition.fromMap(fieldValueMap));
        }
        for (Map fieldValueMap : representation.getCopyFields()) {
            SchemaDefinition.CopyFieldDefinition cf = SchemaDefinition.CopyFieldDefinition.fromMap(fieldValueMap);
            sd.addCopyField(cf);
            if (sd.getFieldDefinition(cf.getSource()) == null) continue;
            sd.getFieldDefinition(cf.getSource()).setCopyFields(cf.getDestination());
        }
        return sd;
    }

    @Override
    public void addField(SchemaDefinition.SchemaField field) {
        if (field instanceof SchemaDefinition.FieldDefinition) {
            this.addField((SchemaDefinition.FieldDefinition)field);
        } else if (field instanceof SchemaDefinition.CopyFieldDefinition) {
            this.addCopyField((SchemaDefinition.CopyFieldDefinition)field);
        }
    }

    private void addField(final SchemaDefinition.FieldDefinition field) {
        this.template.execute(this.collection, new CollectionCallback<Integer>(){

            @Override
            public Integer doInSolr(SolrClient solrClient, String collection) throws SolrServerException, IOException {
                SchemaResponse.UpdateResponse response = (SchemaResponse.UpdateResponse)new SchemaRequest.AddField(field.asMap()).process(solrClient, collection);
                if (DefaultSchemaOperations.this.hasErrors(response)) {
                    throw new SchemaModificationException(String.format("Adding field %s with args %s to collection %s failed with status %s. Server returned %s.", field.getName(), field.asMap(), collection, response.getStatus(), response));
                }
                return response.getStatus();
            }
        });
        if (!CollectionUtils.isEmpty(field.getCopyFields())) {
            SchemaDefinition.CopyFieldDefinition cf = new SchemaDefinition.CopyFieldDefinition();
            cf.setSource(field.getName());
            cf.setDestination(field.getCopyFields());
            this.addCopyField(cf);
        }
    }

    private void addCopyField(final SchemaDefinition.CopyFieldDefinition field) {
        this.template.execute(this.collection, new CollectionCallback<Integer>(){

            @Override
            public Integer doInSolr(SolrClient solrClient, String collection) throws SolrServerException, IOException {
                SchemaResponse.UpdateResponse response = (SchemaResponse.UpdateResponse)new SchemaRequest.AddCopyField(field.getSource(), field.getDestination()).process(solrClient, collection);
                if (DefaultSchemaOperations.this.hasErrors(response)) {
                    throw new SchemaModificationException(String.format("Adding copy field %s with destinations %s to collection %s failed with status %s. Server returned %s.", field.getSource(), field.getDestination(), collection, response.getStatus(), response));
                }
                return response.getStatus();
            }
        });
    }

    @Override
    public void removeField(final String name) {
        this.template.execute(this.collection, new CollectionCallback<Integer>(){

            @Override
            public Integer doInSolr(SolrClient solrClient, String collection) throws SolrServerException, IOException {
                SchemaResponse.UpdateResponse response = (SchemaResponse.UpdateResponse)new SchemaRequest.DeleteField(name).process(solrClient, collection);
                if (DefaultSchemaOperations.this.hasErrors(response)) {
                    throw new SchemaModificationException(String.format("Removing field with name %s from collection %s failed with status %s. Server returned %s.", name, collection, response.getStatus(), response));
                }
                return response.getStatus();
            }
        });
    }

    private boolean hasErrors(SchemaResponse.UpdateResponse response) {
        return response.getStatus() != 0 || response.getResponse() != null && !CollectionUtils.isEmpty((Collection)response.getResponse().getAll("errors"));
    }
}

