/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.schema;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.solr.common.util.ContentStreamBase;
import org.springframework.data.solr.core.schema.ContentParser;

public class MappingJacksonRequestContentParser
implements ContentParser {
    private final ObjectMapper mapper = new ObjectMapper();

    public MappingJacksonRequestContentParser() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public ContentStreamBase.StringStream parse(Object content) {
        JsonNode node = (JsonNode)this.mapper.convertValue(content, JsonNode.class);
        return new ContentStreamBase.StringStream(node.toString());
    }
}

