/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core;

import java.util.HashMap;
import java.util.Map;
import org.springframework.data.solr.core.SolrOperations;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SolrTransactionSynchronizationAdapter
extends TransactionSynchronizationAdapter {
    private Map<Integer, CompletionDelegate> delegates = new HashMap<Integer, CompletionDelegate>(2);
    private final SolrOperations solrOperations;

    SolrTransactionSynchronizationAdapter(SolrOperations solrOperations) {
        this.solrOperations = solrOperations;
    }

    public void afterCompletion(int status) {
        CompletionDelegate delegate = this.delegates.get(status);
        if (delegate != null) {
            delegate.execute(this.solrOperations);
        }
    }

    public void register() {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)this);
    }

    public void registerCompletionDelegate(int transactionStatus, CompletionDelegate completionDelegate) {
        this.delegates.put(transactionStatus, completionDelegate);
    }

    public static class RollbackTransaction
    implements CompletionDelegate {
        private final String collectionName;

        RollbackTransaction(String collectionName) {
            this.collectionName = collectionName;
        }

        @Override
        public void execute(SolrOperations solrOperations) {
            solrOperations.rollback(this.collectionName);
        }
    }

    public static class CommitTransaction
    implements CompletionDelegate {
        private final String collectionName;

        CommitTransaction(String collectionName) {
            this.collectionName = collectionName;
        }

        @Override
        public void execute(SolrOperations solrOperations) {
            solrOperations.commit(this.collectionName);
        }
    }

    public static interface CompletionDelegate {
        public void execute(SolrOperations var1);
    }
}

