/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.geo;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metrics;
import org.springframework.data.solr.core.geo.Point;
import org.springframework.util.Assert;

public final class GeoConverters {

    public static enum Point3DToStringConverter implements Converter<org.springframework.data.geo.Point, String>
    {
        INSTANCE;


        public String convert(org.springframework.data.geo.Point source) {
            Assert.notNull((Object)source, (String)"Source must not be null!");
            String formattedString = StringUtils.stripEnd((String)String.format(Locale.ENGLISH, "%f", source.getX()), (String)"0") + "," + StringUtils.stripEnd((String)String.format(Locale.ENGLISH, "%f", source.getY()), (String)"0");
            if (source instanceof Point) {
                formattedString = formattedString + (((Point)source).getZ() != null ? "," + StringUtils.stripEnd((String)String.format(Locale.ENGLISH, "%f", ((Point)source).getZ()), (String)"0") : "");
            }
            return formattedString.replaceAll("\\.,", "\\.0,").replaceFirst("\\.$", ".0");
        }
    }

    @WritingConverter
    public static enum DistanceToStringConverter implements Converter<Distance, String>
    {
        INSTANCE;


        public String convert(Distance source) {
            Assert.notNull((Object)source, (String)"Source must not be null!");
            double value = source.getValue();
            if (source.getMetric() == Metrics.MILES) {
                value = source.getValue() * 1.609344;
            }
            return String.format(Locale.ENGLISH, "%s", value);
        }
    }

    @ReadingConverter
    public static enum StringToPointConverter implements Converter<String, org.springframework.data.geo.Point>
    {
        INSTANCE;


        public org.springframework.data.geo.Point convert(String source) {
            String[] coordinates = source.split(",");
            return new org.springframework.data.geo.Point(Double.parseDouble(coordinates[0]), Double.parseDouble(coordinates[1]));
        }
    }

    @WritingConverter
    public static enum Point2DToStringConverter implements Converter<org.springframework.data.geo.Point, String>
    {
        INSTANCE;


        public String convert(org.springframework.data.geo.Point source) {
            if (source instanceof Point) {
                return Point3DToStringConverter.INSTANCE.convert((Point)source);
            }
            String formattedString = StringUtils.stripEnd((String)String.format(Locale.ENGLISH, "%f", source.getX()), (String)"0") + "," + StringUtils.stripEnd((String)String.format(Locale.ENGLISH, "%f", source.getY()), (String)"0");
            if (formattedString.endsWith(".")) {
                return formattedString.replace(".", ".0");
            }
            return formattedString;
        }
    }
}

