/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public interface Function {
    public String getOperation();

    public Iterable<?> getArguments();

    public boolean hasArguments();

    default public String toSolrFunction(Context context) {
        StringBuilder sb = new StringBuilder();
        sb.append("{!func}");
        sb.append(this.getOperation());
        sb.append('(');
        if (this.hasArguments()) {
            ArrayList<String> solrReadableArguments = new ArrayList<String>();
            for (Object arg : this.getArguments()) {
                Assert.notNull(arg, (String)"Unable to parse 'null' within function arguments.");
                solrReadableArguments.add(context.convert(arg));
            }
            sb.append(StringUtils.join(solrReadableArguments, (char)','));
        }
        sb.append(')');
        return sb.toString();
    }

    default public Map<String, String> getArgumentMap(Context context) {
        return Collections.emptyMap();
    }

    public static interface Context {
        public String convert(Object var1);

        public Target getTarget();

        public static enum Target {
            SORT,
            PROJECTION,
            QUERY;

        }
    }
}

