/*
 * Copyright 2019-2021 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.aot.build.context;

import java.io.IOException;
import java.nio.file.Path;

/**
 * File generated by the native build tools.
 * <p>This file should be later compiled and/or packaged with the resulting application.
 *
 * @author Brian Clozel
 */
public interface GeneratedFile {

	/**
	 * Write the generated file to the given root path.
	 * 
	 * <p>This method should write the file to the expected location,
	 * given the type of the generated file and relative to the given root path.
	 * @param rootPath the root path for writing generated files
	 * @throws IOException if an I/O error is thrown
	 */
	void writeTo(Path rootPath) throws IOException;

}
