/*
 * Copyright 2023 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.modulith;

import org.springframework.boot.context.event.ApplicationStartedEvent;

/**
 * An interface to be implemented by Spring components that are supposed to be initialized on
 * {@link ApplicationStartedEvent}. They're {@link ApplicationModule} specific as they're executed in the order
 * determined by the dependencies of a module. In other words, {@link ApplicationModuleInitializer} of fundamental
 * application modules are executed first, followed by the ones that depend on it.
 *
 * @author Oliver Drotbohm
 */
public interface ApplicationModuleInitializer {

	/**
	 * Run business logic that's needed to initialize the {@link ApplicationModule}.
	 */
	void initialize();
}
