/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.test;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.modulith.test.ModuleTestExecution;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@Import(value={AutoConfigurationAndEntityScanPackageCustomizer.class})
@AutoConfigureOrder(value=-2147483648)
class ModuleTestAutoConfiguration {
    private static final String AUTOCONFIG_PACKAGES = "org.springframework.boot.autoconfigure.AutoConfigurationPackages";
    private static final String ENTITY_SCAN_PACKAGE = "org.springframework.boot.autoconfigure.domain.EntityScanPackages";

    ModuleTestAutoConfiguration() {
    }

    static class AutoConfigurationAndEntityScanPackageCustomizer
    implements ImportBeanDefinitionRegistrar {
        private static final Logger LOGGER = LoggerFactory.getLogger(AutoConfigurationAndEntityScanPackageCustomizer.class);

        AutoConfigurationAndEntityScanPackageCustomizer() {
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            ModuleTestExecution execution = (ModuleTestExecution)((BeanFactory)registry).getBean(ModuleTestExecution.class);
            List<String> basePackages = execution.getBasePackages().toList();
            LOGGER.info("Re-configuring auto-configuration and entity scan packages to: {}.", (Object)StringUtils.collectionToDelimitedString(basePackages, (String)", "));
            this.setBasePackagesOn(registry, ModuleTestAutoConfiguration.AUTOCONFIG_PACKAGES, "BasePackagesBeanDefinition", "basePackages", basePackages);
            this.setBasePackagesOn(registry, ModuleTestAutoConfiguration.ENTITY_SCAN_PACKAGE, "EntityScanPackagesBeanDefinition", "packageNames", basePackages);
        }

        private void setBasePackagesOn(BeanDefinitionRegistry registry, String beanName, String definitionType, String fieldName, List<String> packages) {
            if (!registry.containsBeanDefinition(beanName)) {
                return;
            }
            BeanDefinition definition = registry.getBeanDefinition(beanName);
            Field field = Arrays.stream(definition.getClass().getDeclaredFields()).filter(__ -> definition.getClass().getSimpleName().equals(definitionType)).filter(it -> it.getName().equals(fieldName)).findFirst().orElse(null);
            if (field != null) {
                ReflectionUtils.makeAccessible((Field)field);
                ((Set)ReflectionUtils.getField((Field)field, (Object)definition)).stream().filter(it -> it.startsWith("org.springframework.modulith")).forEach(packages::add);
                ReflectionUtils.setField((Field)field, (Object)definition, new HashSet<String>(packages));
            } else {
                ConstructorArgumentValues.ValueHolder holder = definition.getConstructorArgumentValues().getArgumentValue(0, String[].class);
                Arrays.stream((String[])holder.getValue()).filter(it -> it.startsWith("org.springframework.modulith")).forEach(packages::add);
                definition.getConstructorArgumentValues().addIndexedArgumentValue(0, packages.toArray(String[]::new));
            }
        }
    }
}

