/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.test;

import com.tngtech.archunit.thirdparty.com.google.common.base.Optional;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.lang.Nullable;
import org.springframework.modulith.test.AssertablePublishedEvents;
import org.springframework.modulith.test.PublishedEvents;
import org.springframework.modulith.test.PublishedEventsAssert;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

@API(status=API.Status.EXPERIMENTAL)
public class Scenario {
    private static final Predicate<Object> DEFAULT_ACCEPTANCE = it -> {
        if (it instanceof Optional) {
            Optional o = (Optional)it;
            return o.isPresent();
        }
        if (it instanceof Boolean) {
            Boolean b = (Boolean)it;
            return b;
        }
        return it != null;
    };
    private final TransactionOperations transactionOperations;
    private final ApplicationEventPublisher publisher;
    private final AssertablePublishedEvents events;

    Scenario(TransactionTemplate transactionTemplate, ApplicationEventPublisher publisher, AssertablePublishedEvents events) {
        Assert.notNull((Object)transactionTemplate, (String)"TransactionTemplate must not be null!");
        Assert.notNull((Object)publisher, (String)"ApplicationEventPublisher must not be null!");
        Assert.notNull((Object)events, (String)"AssertablePublishedEvents must not be null!");
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition((TransactionDefinition)transactionTemplate);
        definition.setPropagationBehavior(3);
        this.transactionOperations = new TransactionTemplate(transactionTemplate.getTransactionManager(), (TransactionDefinition)definition);
        this.publisher = publisher;
        this.events = events;
    }

    public When<Void> publish(Object event) {
        return this.stimulate((TransactionOperations tx, ApplicationEventPublisher e) -> tx.executeWithoutResult(__ -> e.publishEvent(event)));
    }

    public When<Void> publish(Supplier<Object> event) {
        return this.stimulate((TransactionOperations tx, ApplicationEventPublisher e) -> tx.executeWithoutResult(arg_0 -> Scenario.lambda$publish$3(e, (Supplier)event, arg_0)));
    }

    public When<Void> stimulate(Runnable runnable) {
        Assert.notNull((Object)runnable, (String)"Runnable must not be null!");
        return this.stimulate(() -> {
            runnable.run();
            return null;
        });
    }

    public <S> When<S> stimulate(Supplier<S> supplier) {
        return this.stimulate((TransactionOperations tx) -> tx.execute(arg_0 -> Scenario.lambda$stimulate$6((Supplier)supplier, arg_0)));
    }

    public <S> When<S> stimulate(Function<TransactionOperations, S> function) {
        return this.stimulate((TransactionOperations tx, ApplicationEventPublisher __) -> function.apply((TransactionOperations)tx));
    }

    public When<Void> stimulate(BiConsumer<TransactionOperations, ApplicationEventPublisher> stimulus) {
        Assert.notNull(stimulus, (String)"Stimulus must not be null!");
        return this.stimulate((TransactionOperations tx, ApplicationEventPublisher e) -> {
            stimulus.accept((TransactionOperations)tx, (ApplicationEventPublisher)e);
            return null;
        });
    }

    public <S> When<S> stimulate(BiFunction<TransactionOperations, ApplicationEventPublisher, S> stimulus) {
        Assert.notNull(stimulus, (String)"Stimulus must not be null!");
        return new When<Object>(stimulus, __ -> {}, Function.identity());
    }

    private static /* synthetic */ Object lambda$stimulate$6(Supplier supplier, TransactionStatus __) {
        return supplier.get();
    }

    private static /* synthetic */ void lambda$publish$3(ApplicationEventPublisher e, Supplier event, TransactionStatus __) {
        e.publishEvent(event.get());
    }

    public class When<T> {
        private final BiFunction<TransactionOperations, ApplicationEventPublisher, T> stimulus;
        private final Consumer<T> cleanup;
        private final Function<ConditionFactory, ConditionFactory> customizer;

        When(BiFunction<TransactionOperations, ApplicationEventPublisher, T> stimulus, Consumer<T> cleanup, Function<ConditionFactory, ConditionFactory> customizer) {
            this.stimulus = stimulus;
            this.cleanup = cleanup;
            this.customizer = customizer;
        }

        public When<T> andCleanup(Runnable runnable) {
            Assert.notNull((Object)runnable, (String)"Cleanup callback must not be null!");
            return this.andCleanup((T __) -> runnable.run());
        }

        public When<T> andCleanup(Consumer<T> consumer) {
            Assert.notNull(consumer, (String)"Cleanup callback must not be null!");
            return new When<T>(this.stimulus, consumer, this.customizer);
        }

        public When<T> andWaitAtMost(Duration duration) {
            Assert.notNull((Object)duration, (String)"Duration must not be null!");
            return this.customize(it -> it.atMost(duration));
        }

        public When<T> customize(Function<ConditionFactory, ConditionFactory> customizer) {
            Assert.notNull(customizer, (String)"Customizer must not be null!");
            return new When<T>(this.stimulus, this.cleanup, customizer);
        }

        public <E> EventResult<E> forEventOfType(Class<E> type) {
            return this.andWaitForEventOfType(type);
        }

        public <S> StateChangeResult<S> forStateChange(Supplier<S> supplier) {
            return this.forStateChange(supplier, DEFAULT_ACCEPTANCE);
        }

        public <S> StateChangeResult<S> forStateChange(Supplier<S> supplier, Predicate<? super S> acceptanceCriteria) {
            return this.andWaitForStateChange(supplier, acceptanceCriteria);
        }

        public <E> EventResult<E> andWaitForEventOfType(Class<E> type) {
            return new EventResult<E>(type, Function.identity());
        }

        public <S> StateChangeResult<S> andWaitForStateChange(Supplier<S> supplier) {
            return this.andWaitForStateChange(supplier, DEFAULT_ACCEPTANCE);
        }

        public <S> StateChangeResult<S> andWaitForStateChange(Supplier<S> supplier, Predicate<? super S> acceptanceCriteria) {
            Assert.notNull(supplier, (String)"Supplier must not be null!");
            Assert.notNull(acceptanceCriteria, (String)"Acceptance criteria must not be null!");
            return new StateChangeResult<S>(this.awaitInternal(__ -> {}, () -> supplier.get(), acceptanceCriteria));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <S> ExecutionResult<S, T> awaitInternal(Consumer<T> verifications, Callable<S> supplier, Predicate<? super S> condition) {
            T result = this.stimulus.apply(Scenario.this.transactionOperations, Scenario.this.publisher);
            try {
                Object foo = this.customizer.apply(Awaitility.await()).until(supplier, condition);
                verifications.accept(result);
                ExecutionResult<Object, T> executionResult = new ExecutionResult<Object, T>(foo, result);
                return executionResult;
            }
            finally {
                this.cleanup.accept(result);
            }
        }

        public class EventResult<E> {
            private final Class<E> type;
            private final Function<PublishedEvents.TypedPublishedEvents<E>, PublishedEvents.TypedPublishedEvents<E>> filter;

            EventResult(Class<E> type, Function<PublishedEvents.TypedPublishedEvents<E>, PublishedEvents.TypedPublishedEvents<E>> filtered) {
                Assert.notNull(type, (String)"Event type must not be null!");
                this.type = type;
                this.filter = filtered;
            }

            public EventResult<E> matching(Predicate<? super E> filter) {
                Assert.notNull(filter, (String)"Filter must not be null!");
                return new EventResult<E>(this.type, this.createOrAdd(it -> it.matching(filter)));
            }

            public <S> EventResult<E> matchingMapped(Function<E, S> extractor, Predicate<? super S> filter) {
                return new EventResult<E>(this.type, this.createOrAdd(it -> it.matching(extractor, filter)));
            }

            public <S> EventResult<E> matchingMappedValue(Function<E, S> extractor, @Nullable S value) {
                return new EventResult<E>(this.type, this.createOrAdd(it -> it.matching(extractor, value)));
            }

            public void toArrive() {
                this.toArriveAndVerifyInternal(__ -> {});
            }

            public void toArriveAndVerify(Consumer<E> consumer) {
                Assert.notNull(consumer, (String)"Consumer must not be null!");
                this.toArriveAndVerifyInternal(__ -> consumer.accept(this.getFilteredEvents().iterator().next()));
            }

            public void toArriveAndVerify(BiConsumer<E, T> consumer) {
                Assert.notNull(consumer, (String)"Consumer must not be null!");
                this.toArriveAndVerifyInternal(it -> consumer.accept(this.getFilteredEvents().iterator().next(), it));
            }

            public void toArriveAndAssert(Consumer<PublishedEventsAssert.PublishedEventAssert<? super E>> consumer) {
                Assert.notNull(consumer, (String)"Consumer must not be null!");
                this.toArriveAndVerifyInternal(__ -> consumer.accept(this.getAssertedEvent()));
            }

            public void toArriveAndAssert(BiConsumer<PublishedEventsAssert.PublishedEventAssert<? super E>, T> consumer) {
                Assert.notNull(consumer, (String)"Consumer must not be null!");
                this.toArriveAndVerifyInternal(it -> consumer.accept(this.getAssertedEvent(), it));
            }

            private Function<PublishedEvents.TypedPublishedEvents<E>, PublishedEvents.TypedPublishedEvents<E>> createOrAdd(Function<PublishedEvents.TypedPublishedEvents<E>, PublishedEvents.TypedPublishedEvents<E>> filter) {
                return this.filter == null ? filter : this.filter.andThen(filter);
            }

            private PublishedEvents.TypedPublishedEvents<E> getFilteredEvents() {
                return this.filter.apply(Scenario.this.events.ofType(this.type));
            }

            private PublishedEventsAssert.PublishedEventAssert<? super E> getAssertedEvent() {
                return new PublishedEventsAssert(this.getFilteredEvents()).contains(this.type);
            }

            private void toArriveAndVerifyInternal(Consumer<T> verifications) {
                When.this.awaitInternal(verifications, () -> this.getFilteredEvents(), it -> it.eventOfTypeWasPublished(this.type));
            }
        }

        public class StateChangeResult<S> {
            private ExecutionResult<S, T> result;

            StateChangeResult(ExecutionResult<S, T> result) {
                this.result = result;
            }

            public void andVerify(Consumer<S> consumer) {
                Assert.notNull(consumer, (String)"Consumer must not be null!");
                consumer.accept(this.result.first());
            }

            public void andVerify(BiConsumer<S, T> consumer) {
                Assert.notNull(consumer, (String)"BiConsumer must not be null!");
                consumer.accept(this.result.first(), this.result.second());
            }
        }

        private record ExecutionResult<S, T>(S first, T second) {
        }
    }
}

