/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.beans.factory;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.aot.beans.factory.InjectedElementAttributes;
import org.springframework.aot.beans.factory.InjectedElementResolver;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.InjectionPoint;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.BeanDefinitionValueResolverAccessor;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.CollectionFactory;
import org.springframework.core.MethodParameter;

class InjectedConstructionResolver
implements InjectedElementResolver {
    private final Executable executable;
    private final Class<?> targetType;
    private final String beanName;
    private final Function<GenericApplicationContext, BeanDefinition> beanDefinitionResolver;

    InjectedConstructionResolver(Executable executable, Class<?> targetType, String beanName, Function<GenericApplicationContext, BeanDefinition> beanDefinitionResolver) {
        this.executable = executable;
        this.targetType = targetType;
        this.beanName = beanName;
        this.beanDefinitionResolver = beanDefinitionResolver;
    }

    Executable getExecutable() {
        return this.executable;
    }

    @Override
    public InjectedElementAttributes resolve(GenericApplicationContext context, boolean required) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        int argumentCount = this.executable.getParameterCount();
        ArrayList<Object> arguments = new ArrayList<Object>();
        LinkedHashSet autowiredBeans = new LinkedHashSet(argumentCount);
        TypeConverter typeConverter = beanFactory.getTypeConverter();
        ConstructorArgumentValues argumentValues = this.resolveArgumentValues(context);
        for (int i = 0; i < argumentCount; ++i) {
            MethodParameter methodParam = this.createMethodParameter(i);
            ConstructorArgumentValues.ValueHolder valueHolder = argumentValues.getIndexedArgumentValue(i, null);
            if (valueHolder != null) {
                if (valueHolder.isConverted()) {
                    arguments.add(valueHolder.getConvertedValue());
                    continue;
                }
                Object userValue = context.getBeanFactory().getTypeConverter().convertIfNecessary(valueHolder.getValue(), methodParam.getParameterType());
                arguments.add(userValue);
                continue;
            }
            DependencyDescriptor depDescriptor = new DependencyDescriptor(methodParam, true);
            depDescriptor.setContainingClass(this.targetType);
            try {
                Object arg = this.resolveDependency(() -> beanFactory.resolveDependency(depDescriptor, this.beanName, autowiredBeans, typeConverter), methodParam.getParameterType());
                arguments.add(arg);
                continue;
            }
            catch (BeansException ex) {
                throw new UnsatisfiedDependencyException(null, this.beanName, new InjectionPoint(methodParam), ex);
            }
        }
        return new InjectedElementAttributes(arguments);
    }

    private Object resolveDependency(Supplier<Object> resolvedDependency, Class<?> dependencyType) {
        try {
            return resolvedDependency.get();
        }
        catch (NoSuchBeanDefinitionException ex) {
            if (dependencyType.isArray()) {
                return Array.newInstance(dependencyType.getComponentType(), 0);
            }
            if (CollectionFactory.isApproximableCollectionType(dependencyType)) {
                return CollectionFactory.createCollection(dependencyType, (int)0);
            }
            if (CollectionFactory.isApproximableMapType(dependencyType)) {
                return CollectionFactory.createMap(dependencyType, (int)0);
            }
            throw ex;
        }
    }

    private ConstructorArgumentValues resolveArgumentValues(GenericApplicationContext context) {
        ConstructorArgumentValues resolvedValues = new ConstructorArgumentValues();
        BeanDefinition beanDefinition = this.beanDefinitionResolver.apply(context);
        if (beanDefinition == null || !beanDefinition.hasConstructorArgumentValues()) {
            return resolvedValues;
        }
        ConstructorArgumentValues argumentValues = beanDefinition.getConstructorArgumentValues();
        BeanDefinitionValueResolverAccessor.ValueResolver valueResolver = BeanDefinitionValueResolverAccessor.get(context, this.beanName, beanDefinition);
        for (Map.Entry entry : argumentValues.getIndexedArgumentValues().entrySet()) {
            int index = (Integer)entry.getKey();
            ConstructorArgumentValues.ValueHolder valueHolder = (ConstructorArgumentValues.ValueHolder)entry.getValue();
            if (valueHolder.isConverted()) {
                resolvedValues.addIndexedArgumentValue(index, valueHolder);
                continue;
            }
            Object resolvedValue = valueResolver.resolveValueIfNecessary("constructor argument", valueHolder.getValue());
            ConstructorArgumentValues.ValueHolder resolvedValueHolder = new ConstructorArgumentValues.ValueHolder(resolvedValue, valueHolder.getType(), valueHolder.getName());
            resolvedValueHolder.setSource((Object)valueHolder);
            resolvedValues.addIndexedArgumentValue(index, resolvedValueHolder);
        }
        return resolvedValues;
    }

    private MethodParameter createMethodParameter(int index) {
        if (this.executable instanceof Constructor) {
            return new MethodParameter((Constructor)this.executable, index);
        }
        return new MethodParameter((Method)this.executable, index);
    }

    public String toString() {
        return new StringJoiner(", ", InjectedConstructionResolver.class.getSimpleName() + "[", "]").add("executable=" + this.executable).toString();
    }
}

