/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.test.boot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import org.springframework.aot.SpringApplicationAotUtils;
import org.springframework.aot.test.boot.AotTestSpringApplication;
import org.springframework.boot.ApplicationContextFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.test.context.SpringBootContextLoader;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.web.SpringBootMockServletContext;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.boot.web.reactive.context.GenericReactiveWebApplicationContext;
import org.springframework.boot.web.servlet.support.ServletContextApplicationContextInitializer;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.TestPropertySourceUtils;
import org.springframework.test.context.web.WebMergedContextConfiguration;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class AotSpringBootConfigContextLoader
extends SpringBootContextLoader {
    private final Class<? extends ApplicationContextInitializer<?>> testContextInitializer;
    private final WebApplicationType webApplicationType;
    private final SpringBootTest.WebEnvironment webEnvironment;

    public AotSpringBootConfigContextLoader(Class<? extends ApplicationContextInitializer<?>> testContextInitializer, WebApplicationType webApplicationType, SpringBootTest.WebEnvironment webEnvironment) {
        this.testContextInitializer = testContextInitializer;
        this.webApplicationType = webApplicationType;
        this.webEnvironment = webEnvironment;
    }

    public AotSpringBootConfigContextLoader(Class<? extends ApplicationContextInitializer<?>> testContextInitializer) {
        this(testContextInitializer, WebApplicationType.NONE, SpringBootTest.WebEnvironment.NONE);
    }

    public ConfigurableApplicationContext loadContext(MergedContextConfiguration config) {
        String[] args = new String[]{};
        AotTestSpringApplication application = new AotTestSpringApplication(config.getTestClass().getClassLoader(), this.testContextInitializer);
        application.setMainApplicationClass(config.getTestClass());
        application.setSources(Collections.singleton(this.testContextInitializer.getName()));
        ConfigurableEnvironment environment = this.getEnvironment();
        if (!ObjectUtils.isEmpty((Object[])config.getActiveProfiles())) {
            this.setActiveProfiles(environment, config.getActiveProfiles());
        }
        TestPropertySourceUtils.addPropertiesFilesToEnvironment((ConfigurableEnvironment)environment, (ResourceLoader)application.getResourceLoader(), (String[])config.getPropertySourceLocations());
        TestPropertySourceUtils.addInlinedPropertiesToEnvironment((ConfigurableEnvironment)environment, (String[])this.getInlinedProperties(config));
        application.setEnvironment(environment);
        application.setApplicationContextFactory(SpringApplicationAotUtils.AOT_FACTORY);
        application.setWebApplicationType(this.webApplicationType);
        if (!this.isEmbeddedWebEnvironment()) {
            if (this.webApplicationType == WebApplicationType.SERVLET) {
                ArrayList initializers = new ArrayList(application.getInitializers());
                new WebConfigurer().configure(config, application, initializers);
                application.setInitializers(initializers);
            } else if (this.webApplicationType == WebApplicationType.REACTIVE) {
                application.setApplicationContextFactory(ApplicationContextFactory.of(GenericReactiveWebApplicationContext::new));
            }
        }
        ConfigurableApplicationContext context = application.run(args);
        return context;
    }

    private boolean isEmbeddedWebEnvironment() {
        return this.webEnvironment.isEmbedded();
    }

    private void setActiveProfiles(ConfigurableEnvironment environment, String[] profiles) {
        environment.setActiveProfiles(profiles);
        String[] pairs = new String[profiles.length];
        for (int i = 0; i < profiles.length; ++i) {
            pairs[i] = "spring.profiles.active[" + i + "]=" + profiles[i];
        }
        TestPropertyValues.of((String[])pairs).applyTo(environment);
    }

    private static class WebConfigurer {
        private WebConfigurer() {
        }

        void configure(MergedContextConfiguration configuration, SpringApplication application, List<ApplicationContextInitializer<?>> initializers) {
            WebMergedContextConfiguration webConfiguration = (WebMergedContextConfiguration)configuration;
            this.addMockServletContext(initializers, webConfiguration);
            application.setApplicationContextFactory(webApplicationType -> new GenericWebApplicationContext());
        }

        private void addMockServletContext(List<ApplicationContextInitializer<?>> initializers, WebMergedContextConfiguration webConfiguration) {
            SpringBootMockServletContext servletContext = new SpringBootMockServletContext(webConfiguration.getResourceBasePath());
            initializers.add(0, (ApplicationContextInitializer<?>)new ServletContextApplicationContextInitializer((ServletContext)servletContext, true));
        }
    }
}

