/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.test.context.support;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AbstractGenericContextLoader;

public class AotDefaultConfigContextLoader
extends AbstractGenericContextLoader {
    private final Class<? extends ApplicationContextInitializer<?>> testContextInitializer;

    public AotDefaultConfigContextLoader(Class<? extends ApplicationContextInitializer<?>> testContextInitializer) {
        this.testContextInitializer = testContextInitializer;
    }

    protected void loadBeanDefinitions(GenericApplicationContext context, MergedContextConfiguration mergedConfig) {
        ApplicationContextInitializer applicationContextInitializer = (ApplicationContextInitializer)BeanUtils.instantiateClass(this.testContextInitializer);
        applicationContextInitializer.initialize((ConfigurableApplicationContext)context);
    }

    protected void customizeContext(GenericApplicationContext context) {
        this.safeRemoveBeanDefinitions(context, "org.springframework.context.annotation.internalAutowiredAnnotationProcessor", "org.springframework.context.annotation.internalCommonAnnotationProcessor", "org.springframework.context.annotation.internalConfigurationAnnotationProcessor", "org.springframework.context.annotation.internalConfigurationBeanNameGenerator", "org.springframework.context.event.internalEventListenerFactory", "org.springframework.context.event.internalEventListenerProcessor");
    }

    private void safeRemoveBeanDefinitions(GenericApplicationContext context, String ... names) {
        for (String name : names) {
            if (!context.containsBeanDefinition(name)) continue;
            context.removeBeanDefinition(name);
        }
    }

    protected BeanDefinitionReader createBeanDefinitionReader(GenericApplicationContext context) {
        throw new UnsupportedOperationException("AotAnnotationConfigContextLoader does not support the createBeanDefinitionReader(GenericApplicationContext) method");
    }

    protected String getResourceSuffix() {
        throw new UnsupportedOperationException("AotAnnotationConfigContextLoader does not support the getResourceSuffix() method");
    }
}

