/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.nativex;

import org.springframework.core.NativeDetector;
import org.springframework.nativex.GeneratedClassNotFoundException;
import org.springframework.util.ClassUtils;

public abstract class AotModeDetector {
    private static final String GENERATED_CLASS = "org.springframework.aot.StaticSpringFactories";
    private static final boolean generatedClassPresent = ClassUtils.isPresent((String)"org.springframework.aot.StaticSpringFactories", null);
    private static final boolean generatedTestClassPresent = ClassUtils.isPresent((String)"org.springframework.aot.TestContextBootstrapInitializer", null);
    private static final boolean aotTestClassPresent = ClassUtils.isPresent((String)"org.springframework.aot.test.context.bootstrap.generator.AotTestContextProcessor", null);

    public static boolean isAotModeEnabled() {
        if ("true".equals(System.getProperty("springAot")) || NativeDetector.inNativeImage()) {
            if (!generatedClassPresent) {
                throw new GeneratedClassNotFoundException(GENERATED_CLASS);
            }
            return true;
        }
        return false;
    }

    public static boolean isRunningAotTests() {
        return generatedTestClassPresent && !aotTestClassPresent;
    }

    public static boolean isGeneratingAotTests() {
        return aotTestClassPresent;
    }
}

