/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.nativex;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.NativeDetector;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.nativex.AotModeDetector;
import org.springframework.nativex.utils.NativeUtils;
import org.springframework.util.ClassUtils;

public class NativeListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    private static final Log logger = LogFactory.getLog(NativeListener.class);

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        if (AotModeDetector.isAotModeEnabled() || AotModeDetector.isRunningAotTests()) {
            logger.info((Object)"This application is bootstrapped with code generated with Spring AOT");
            ConfigurableEnvironment environment = event.getEnvironment();
            environment.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("native", NativeUtils.getNativeProperties()));
        }
    }

    static {
        if (!NativeDetector.inNativeImage()) {
            System.setProperty("org.graalvm.nativeimage.imagecode", "runtime");
        }
        if (ClassUtils.isPresent((String)"org.hibernate.Session", null)) {
            System.setProperty("hibernate.bytecode.provider", "none");
        }
    }
}

