/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.nativex.substitutions.framework;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.lang.reflect.Constructor;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.nativex.substitutions.OnlyIfPresent;
import org.springframework.util.Assert;

@TargetClass(className="org.springframework.beans.BeanUtils", onlyWith={OnlyIfPresent.class})
final class Target_BeanUtils {
    Target_BeanUtils() {
    }

    @Substitute
    public static <T> T instantiateClass(Class<T> clazz) throws BeanInstantiationException {
        Constructor<T> ctor;
        block3: {
            Assert.notNull(clazz, (String)"Class must not be null");
            if (clazz.isInterface()) {
                throw new BeanInstantiationException(clazz, "Specified class is an interface");
            }
            try {
                ctor = clazz.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                ctor = Target_BeanUtils.findPrimaryConstructor(clazz);
                if (ctor != null) break block3;
                throw new BeanInstantiationException(clazz, "No default constructor found", (Throwable)ex);
            }
        }
        return Target_BeanUtils.instantiateClass(ctor, new Object[0]);
    }

    @Alias
    public static <T> T instantiateClass(Constructor<T> ctor, Object ... args) throws BeanInstantiationException {
        return null;
    }

    @Alias
    public static <T> Constructor<T> findPrimaryConstructor(Class<T> clazz) {
        return null;
    }
}

