/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.core;

import flex.messaging.MessageException;
import java.util.HashSet;
import java.util.Set;
import org.springframework.aop.ThrowsAdvice;
import org.springframework.flex.core.ExceptionTranslator;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionTranslationAdvice
implements ThrowsAdvice {
    private static final String SERVER_PROCESSING_CODE = "Server.Processing";
    private Set<ExceptionTranslator> exceptionTranslators = new HashSet<ExceptionTranslator>();

    public void afterThrowing(Throwable original) throws Throwable {
        MessageException me;
        Class<?> candidateType = original.getClass();
        Throwable candidate = original;
        if (ClassUtils.isAssignable(MessageException.class, candidateType) && SERVER_PROCESSING_CODE.equals((me = (MessageException)candidate).getCode()) && me.getRootCause() != null) {
            candidateType = me.getRootCause().getClass();
            candidate = me.getRootCause();
        }
        for (ExceptionTranslator translator : this.exceptionTranslators) {
            MessageException result;
            if (!translator.handles(candidateType) || (result = translator.translate(candidate)) == null) continue;
            throw result;
        }
        throw original;
    }

    public Set<ExceptionTranslator> getExceptionTranslators() {
        return this.exceptionTranslators;
    }

    public void setExceptionTranslators(Set<ExceptionTranslator> translators) {
        this.exceptionTranslators = translators;
    }
}

