/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.security;

import flex.messaging.MessageBroker;
import flex.messaging.security.LoginCommand;
import flex.messaging.security.LoginManager;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import org.springframework.flex.config.MessageBrokerConfigProcessor;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.util.Assert;

public class SpringSecurityLoginCommand
implements LoginCommand,
MessageBrokerConfigProcessor {
    private final AuthenticationManager authManager;
    private boolean perClientAuthentication = false;

    public SpringSecurityLoginCommand(AuthenticationManager authManager) {
        Assert.notNull((Object)authManager, (String)"AuthenticationManager is required.");
        this.authManager = authManager;
    }

    public Principal doAuthentication(String username, Object credentials) {
        Authentication authentication = this.authManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)this.extractPassword(credentials)));
        SecurityContextHolder.getContext().setAuthentication(authentication);
        return authentication;
    }

    public boolean doAuthorization(Principal principal, List roles) {
        Assert.isInstanceOf(Authentication.class, (Object)principal, (String)("This LoginCommand expects a Principal of type " + Authentication.class.getName()));
        Authentication auth = (Authentication)principal;
        if (auth == null || auth.getPrincipal() == null || auth.getAuthorities() == null) {
            return false;
        }
        int i = 0;
        while (i < auth.getAuthorities().length) {
            if (roles.contains(auth.getAuthorities()[i].getAuthority())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public AuthenticationManager getAuthManager() {
        return this.authManager;
    }

    public boolean isPerClientAuthentication() {
        return this.perClientAuthentication;
    }

    public boolean logout(Principal principal) {
        SecurityContextHolder.clearContext();
        return true;
    }

    public MessageBroker processAfterStartup(MessageBroker broker) {
        return broker;
    }

    public MessageBroker processBeforeStartup(MessageBroker broker) {
        LoginManager loginManager = broker.getLoginManager();
        loginManager.setLoginCommand((LoginCommand)this);
        loginManager.setPerClientAuthentication(this.perClientAuthentication);
        return broker;
    }

    public void setPerClientAuthentication(boolean perClientAuthentication) {
        this.perClientAuthentication = perClientAuthentication;
    }

    public void start(ServletConfig config) {
    }

    public void stop() {
        SecurityContextHolder.clearContext();
    }

    protected String extractPassword(Object credentials) {
        String password = null;
        if (credentials instanceof String) {
            password = (String)credentials;
        } else if (credentials instanceof Map) {
            password = (String)((Map)credentials).get("password");
        }
        return password;
    }
}

