/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.core;

import flex.messaging.Destination;
import flex.messaging.FlexContext;
import flex.messaging.MessageBroker;
import flex.messaging.services.Service;
import flex.messaging.services.ServiceAdapter;
import java.util.ArrayList;
import javax.servlet.ServletConfig;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletConfigAware;

public abstract class AbstractDestinationFactory
implements InitializingBean,
DisposableBean,
BeanNameAware,
BeanFactoryAware,
ServletConfigAware {
    private volatile String destinationId;
    private volatile String beanName;
    private String[] channels;
    private MessageBroker broker;
    private BeanFactory beanFactory;
    private String serviceAdapter;
    private ServletConfig servletConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.broker, (String)"The 'messageBroker' property is required.");
        try {
            FlexContext.setThreadLocalMessageBroker((MessageBroker)this.broker);
            FlexContext.setThreadLocalServletConfig((ServletConfig)this.servletConfig);
            Destination destination = this.createDestination(this.getDestinationId(), this.broker);
            this.configureAdapter(destination);
            this.configureChannels(destination);
            this.initializeDestination(destination);
        }
        finally {
            FlexContext.clearThreadLocalObjects();
        }
    }

    public final void destroy() throws Exception {
        if (this.broker == null || !this.broker.isStarted()) {
            return;
        }
        this.destroyDestination(this.getDestinationId(), this.broker);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setChannels(String[] channels) {
        this.channels = StringUtils.trimArrayElements((String[])channels);
    }

    public void setDestinationId(String destinationId) {
        this.destinationId = destinationId;
    }

    public void setMessageBroker(MessageBroker broker) {
        this.broker = broker;
    }

    public void setServiceAdapter(String serviceAdapter) {
        this.serviceAdapter = serviceAdapter;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    protected void configureAdapter(Destination destination) {
        String adapterId;
        String string = adapterId = StringUtils.hasText((String)this.serviceAdapter) ? this.serviceAdapter : this.getTargetService(this.broker).getDefaultAdapter();
        if (this.beanFactory.containsBean(adapterId)) {
            ServiceAdapter adapter = (ServiceAdapter)this.beanFactory.getBean(adapterId, ServiceAdapter.class);
            destination.setAdapter(adapter);
        } else if (destination.getAdapter() == null) {
            destination.createAdapter(adapterId);
        }
    }

    protected abstract Destination createDestination(String var1, MessageBroker var2) throws Exception;

    protected abstract void destroyDestination(String var1, MessageBroker var2) throws Exception;

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected String getDestinationId() {
        return StringUtils.hasText((String)this.destinationId) ? this.destinationId : this.beanName;
    }

    protected abstract Service getTargetService(MessageBroker var1);

    protected abstract void initializeDestination(Destination var1) throws Exception;

    private void configureChannels(Destination destination) {
        if (ObjectUtils.isEmpty((Object[])this.channels)) {
            return;
        }
        for (String channelId : this.channels) {
            Assert.isTrue((boolean)this.broker.getChannelIds().contains(channelId), (String)("The channel " + channelId + " is not known to the MessageBroker " + this.broker.getId() + " and cannot be set on the destination " + this.getDestinationId()));
        }
        ArrayList<String> channelsList = new ArrayList<String>();
        for (String channel : this.channels) {
            channelsList.add(channel);
        }
        destination.setChannels(channelsList);
    }
}

