/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.core.io;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.flex.core.io.AbstractAmfConversionServiceConfigProcessor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.SystemPropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathScanningAmfConversionServiceConfigProcessor
extends AbstractAmfConversionServiceConfigProcessor
implements ResourceLoaderAware,
BeanClassLoaderAware {
    private static final String DEFAULT_RESOURCE_PATTERN = "**/*.class";
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
    private String resourcePattern = "**/*.class";
    private ClassLoader beanClassLoader;
    private List<TypeFilter> includeFilters = new LinkedList<TypeFilter>();
    private List<TypeFilter> excludeFilters = new LinkedList<TypeFilter>();
    private final String basePackage;

    public ClassPathScanningAmfConversionServiceConfigProcessor(String basePackage) {
        this.basePackage = basePackage;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (CollectionUtils.isEmpty(this.includeFilters)) {
            this.addIncludeFilter(new IncludeAllFilter());
        }
        super.afterPropertiesSet();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
        this.metadataReaderFactory = new CachingMetadataReaderFactory(resourceLoader);
    }

    public final ResourceLoader getResourceLoader() {
        return this.resourcePatternResolver;
    }

    public void setResourcePattern(String resourcePattern) {
        Assert.notNull((Object)resourcePattern, (String)"'resourcePattern' must not be null");
        this.resourcePattern = resourcePattern;
    }

    public void setIncludeFilters(List<TypeFilter> includeFilters) {
        this.includeFilters = includeFilters;
    }

    public void setExcludeFilters(List<TypeFilter> excludeFilters) {
        this.excludeFilters = excludeFilters;
    }

    public void addIncludeFilter(TypeFilter includeFilter) {
        this.includeFilters.add(includeFilter);
    }

    public void addExcludeFilter(TypeFilter excludeFilter) {
        this.excludeFilters.add(0, excludeFilter);
    }

    @Override
    protected Set<Class<?>> findTypesToRegister() {
        HashSet typesToRegister = new HashSet();
        try {
            String packageSearchPath = "classpath*:" + this.resolveBasePackage(this.basePackage) + "/" + this.resourcePattern;
            Resource[] resources = this.resourcePatternResolver.getResources(packageSearchPath);
            boolean traceEnabled = this.log.isTraceEnabled();
            boolean debugEnabled = this.log.isDebugEnabled();
            for (Resource resource : resources) {
                if (traceEnabled) {
                    this.log.trace((Object)("Scanning " + resource));
                }
                if (resource.isReadable()) {
                    try {
                        MetadataReader metadataReader = this.metadataReaderFactory.getMetadataReader(resource);
                        if (this.applyFilters(metadataReader)) {
                            if (this.isCandidateForAmf(metadataReader.getAnnotationMetadata())) {
                                if (debugEnabled) {
                                    this.log.debug((Object)("Identified candidate AMF class: " + resource));
                                }
                                typesToRegister.add(ClassUtils.forName((String)metadataReader.getAnnotationMetadata().getClassName(), (ClassLoader)this.beanClassLoader));
                                continue;
                            }
                            if (!debugEnabled) continue;
                            this.log.debug((Object)("Ignored because not a concrete top-level class: " + resource));
                            continue;
                        }
                        if (!traceEnabled) continue;
                        this.log.trace((Object)("Ignored because not matching any filter: " + resource));
                        continue;
                    }
                    catch (Throwable ex) {
                        throw new BeanDefinitionStoreException("Failed to read candidate AMF class: " + resource, ex);
                    }
                }
                if (!traceEnabled) continue;
                this.log.trace((Object)("Ignored because not readable: " + resource));
            }
        }
        catch (IOException ex) {
            throw new BeanDefinitionStoreException("I/O failure during classpath scanning", (Throwable)ex);
        }
        return typesToRegister;
    }

    protected String resolveBasePackage(String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)basePackage));
    }

    protected boolean applyFilters(MetadataReader metadataReader) throws IOException {
        for (TypeFilter tf : this.excludeFilters) {
            if (!tf.match(metadataReader, this.metadataReaderFactory)) continue;
            return false;
        }
        for (TypeFilter tf : this.includeFilters) {
            if (!tf.match(metadataReader, this.metadataReaderFactory)) continue;
            return true;
        }
        return false;
    }

    protected boolean isCandidateForAmf(AnnotationMetadata metadata) {
        return metadata.isConcrete() && metadata.isIndependent();
    }

    private final class IncludeAllFilter
    implements TypeFilter {
        private IncludeAllFilter() {
        }

        public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
            return ClassPathScanningAmfConversionServiceConfigProcessor.this.isCandidateForAmf(metadataReader.getAnnotationMetadata());
        }
    }
}

