/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.core.io;

import flex.messaging.io.BeanProxy;
import flex.messaging.io.amf.ASObject;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessor;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.flex.core.io.AmfCreator;
import org.springframework.flex.core.io.AmfIgnore;
import org.springframework.flex.core.io.AmfIgnoreField;
import org.springframework.flex.core.io.AmfProperty;
import org.springframework.flex.core.io.PropertyProxyUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringPropertyProxy
extends BeanProxy {
    private static final Log log = LogFactory.getLog(SpringPropertyProxy.class);
    private static final long serialVersionUID = 5374027421774405789L;
    private List<String> propertyNames;
    protected final ConversionService conversionService;
    protected final Class<?> beanType;
    protected final boolean useDirectFieldAccess;

    public static SpringPropertyProxy proxyFor(Class<?> beanType, boolean useDirectFieldAccess, ConversionService conversionService) {
        if (PropertyProxyUtils.hasAmfCreator(beanType)) {
            DelayedWriteSpringPropertyProxy proxy = new DelayedWriteSpringPropertyProxy(beanType, useDirectFieldAccess, conversionService);
            return proxy;
        }
        Assert.isTrue((boolean)ClassUtils.hasConstructor(beanType, (Class[])new Class[0]), (String)("Failed to create SpringPropertyProxy for " + beanType.getName() + " - Classes mapped " + "for deserialization from AMF must have either a no-arg default constructor, " + "or a constructor annotated with " + AmfCreator.class.getName()));
        SpringPropertyProxy proxy = new SpringPropertyProxy(beanType, useDirectFieldAccess, conversionService);
        try {
            Object instance = BeanUtils.instantiate(beanType);
            proxy.setPropertyNames(PropertyProxyUtils.findPropertyNames(conversionService, useDirectFieldAccess, instance));
        }
        catch (BeanInstantiationException ex) {
            // empty catch block
        }
        return proxy;
    }

    private SpringPropertyProxy(Class<?> beanType, boolean useDirectFieldAccess, ConversionService conversionService) {
        super(null);
        this.beanType = beanType;
        this.useDirectFieldAccess = useDirectFieldAccess;
        this.conversionService = conversionService;
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    public Object getInstanceToSerialize(Object instance) {
        if (this.conversionService.canConvert(instance.getClass(), this.beanType)) {
            return this.conversionService.convert(instance, this.beanType);
        }
        return instance;
    }

    public List<String> getPropertyNames(Object instance) {
        if (!CollectionUtils.isEmpty(this.propertyNames) && instance.getClass().equals(this.beanType)) {
            return this.propertyNames;
        }
        return PropertyProxyUtils.findPropertyNames(this.conversionService, this.useDirectFieldAccess, instance);
    }

    public Class<?> getType(Object instance, String propertyName) {
        return PropertyProxyUtils.getPropertyAccessor(this.conversionService, this.useDirectFieldAccess, instance).getPropertyType(propertyName);
    }

    public Object getValue(Object instance, String propertyName) {
        TypeDescriptor sourceType;
        PropertyAccessor accessor = PropertyProxyUtils.getPropertyAccessor(this.conversionService, this.useDirectFieldAccess, instance);
        Object value = accessor.getPropertyValue(propertyName);
        if (log.isDebugEnabled()) {
            this.getType(instance, propertyName);
            log.debug((Object)("Actual type of value for property '" + propertyName + "' on instance " + instance + " is " + (value != null ? value.getClass() : null)));
        }
        TypeDescriptor targetType = accessor.getPropertyTypeDescriptor(propertyName);
        TypeDescriptor typeDescriptor = sourceType = value == null ? targetType : TypeDescriptor.valueOf(value.getClass());
        if (this.conversionService.canConvert(sourceType, targetType)) {
            value = this.conversionService.convert(value, sourceType, targetType);
        }
        return value;
    }

    public boolean isWriteOnly(Object instance, String propertyName) {
        PropertyAccessor accessor = PropertyProxyUtils.getPropertyAccessor(this.conversionService, this.useDirectFieldAccess, instance);
        return this.isReadIgnored(instance, propertyName) || !accessor.isReadableProperty(propertyName) && accessor.isWritableProperty(propertyName);
    }

    public void setValue(Object instance, String propertyName, Object value) {
        if (!this.isWriteIgnored(instance, propertyName)) {
            PropertyProxyUtils.getPropertyAccessor(this.conversionService, this.useDirectFieldAccess, instance).setPropertyValue(propertyName, value);
        }
    }

    private void setPropertyNames(List<String> propertyNames) {
        this.propertyNames = propertyNames;
    }

    private boolean isReadIgnored(Object instance, String propertyName) {
        PropertyAccessor accessor = PropertyProxyUtils.getPropertyAccessor(this.conversionService, this.useDirectFieldAccess, instance);
        if (!accessor.isReadableProperty(propertyName)) {
            return true;
        }
        if (this.useDirectFieldAccess) {
            AmfIgnoreField ignoreField = (AmfIgnoreField)accessor.getPropertyTypeDescriptor(propertyName).getAnnotation(AmfIgnoreField.class);
            return ignoreField != null && ignoreField.onSerialization();
        }
        PropertyDescriptor pd = ((BeanWrapper)accessor).getPropertyDescriptor(propertyName);
        return pd.getReadMethod().getAnnotation(AmfIgnore.class) != null;
    }

    private boolean isWriteIgnored(Object instance, String propertyName) {
        PropertyAccessor accessor = PropertyProxyUtils.getPropertyAccessor(this.conversionService, this.useDirectFieldAccess, instance);
        if (!accessor.isWritableProperty(propertyName)) {
            return true;
        }
        if (this.useDirectFieldAccess) {
            AmfIgnoreField ignoreField = (AmfIgnoreField)accessor.getPropertyTypeDescriptor(propertyName).getAnnotation(AmfIgnoreField.class);
            return ignoreField != null && ignoreField.onDeserialization();
        }
        PropertyDescriptor pd = ((BeanWrapper)accessor).getPropertyDescriptor(propertyName);
        return pd.getWriteMethod().getAnnotation(AmfIgnore.class) != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DelayedWriteSpringPropertyProxy
    extends SpringPropertyProxy {
        private static final long serialVersionUID = -5330475591068260312L;
        private final Constructor<?> amfConstructor;
        private final List<String> paramNames = new ArrayList<String>();

        private DelayedWriteSpringPropertyProxy(Class<?> beanType, boolean useDirectFieldAccess, ConversionService conversionService) {
            super(beanType, useDirectFieldAccess, conversionService);
            this.amfConstructor = this.findAmfConstructor();
        }

        public Object createInstance(String className) {
            Assert.isTrue((boolean)this.beanType.getName().equals(className), (String)"Asked to create instance of an unknown type.");
            return new ASObject(className);
        }

        public Object instanceComplete(Object instance) {
            Assert.isInstanceOf(ASObject.class, (Object)instance, (String)("Expected an instance of " + ASObject.class.getName()));
            ASObject sourceInstance = (ASObject)instance;
            Assert.notNull((Object)sourceInstance.getType(), (String)"Expected an explicit type to be set on the ASObject instance passed to this PropertyProxy.");
            Object targetInstance = this.createTargetInstance(sourceInstance);
            this.applyPropertyValues(sourceInstance, targetInstance);
            return targetInstance;
        }

        @Override
        public void setValue(Object instance, String propertyName, Object value) {
            if (instance instanceof ASObject) {
                ((ASObject)instance).put((Object)propertyName, value);
            } else {
                super.setValue(instance, propertyName, value);
            }
        }

        private Object createTargetInstance(ASObject sourceInstance) {
            Object[] params = new Object[this.paramNames.size()];
            for (int i = 0; i < params.length; ++i) {
                TypeDescriptor sourceType;
                Object value = sourceInstance.remove((Object)this.paramNames.get(i));
                TypeDescriptor targetType = TypeDescriptor.valueOf(this.amfConstructor.getParameterTypes()[i]);
                TypeDescriptor typeDescriptor = sourceType = value == null ? targetType : TypeDescriptor.valueOf(value.getClass());
                if (this.conversionService.canConvert(sourceType, targetType)) {
                    value = this.conversionService.convert(value, sourceType, targetType);
                }
                params[i] = value;
            }
            try {
                return this.amfConstructor.newInstance(params);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Failed to invoke constructor marked with " + AmfCreator.class.getName() + " for type " + this.beanType, ex);
            }
        }

        private Object applyPropertyValues(ASObject sourceInstance, Object targetInstance) {
            for (Object property : sourceInstance.keySet()) {
                this.setValue(targetInstance, property.toString(), sourceInstance.get(property));
            }
            return targetInstance;
        }

        private Constructor<?> findAmfConstructor() {
            for (Constructor<?> c : this.beanType.getConstructors()) {
                if (!c.isAnnotationPresent(AmfCreator.class)) continue;
                Assert.isTrue((c.getParameterAnnotations().length == c.getParameterTypes().length ? 1 : 0) != 0, (String)("Found a constructor marked with " + AmfCreator.class.getName() + " but not all of its parameters are marked with " + AmfProperty.class.getName()));
                for (Annotation[] paramAnnotations : c.getParameterAnnotations()) {
                    boolean hasAmfProperty = false;
                    for (Annotation paramAnnotation : paramAnnotations) {
                        if (!paramAnnotation.annotationType().equals(AmfProperty.class)) continue;
                        hasAmfProperty = true;
                        this.paramNames.add(((AmfProperty)paramAnnotation).value());
                        break;
                    }
                    Assert.isTrue((boolean)hasAmfProperty, (String)("Found a constructor marked with " + AmfCreator.class.getName() + " but not all of its parameters are marked with " + AmfProperty.class.getName()));
                }
                return c;
            }
            throw new IllegalStateException("An instance of " + this.beanType + " could note be created.  Must either have a public no-arg constructor, or a constructor annotated with " + AmfCreator.class.getName() + ".");
        }
    }
}

